<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Models\Banner;
use App\Models\CurrentAffair;
use App\Models\CurrentMainCategory;
use App\Models\CurrentSubCategory;
use App\Models\DailyMainCategory;
use App\Models\DailyNews;
use App\Models\Ebook;
use App\Models\EbookMainCategory;
use App\Models\EbookSub2Category;
use App\Models\EbookSubCategory;
use App\Models\Exam;
use App\Models\ExamMainCategory;
use App\Models\ExamSub2Category;
use App\Models\ExamSubCategory;
use App\Models\Language;
use App\Models\QuestionAnswer;
use App\Models\QuestMainCategory;
use App\Models\QuestSubCategory;
use App\Models\QuizMainCategory;
use App\Models\QuizQuestion;
use App\Models\QuizSub2Category;
use App\Models\QuizSubCategory;
use Illuminate\Http\Request;

class ApiController extends Controller
{
    public function language($id = null)
    {
        if ($id != null) {
            $data = Language::where(['status' => 1, 'id' => $id])->get();
        } else {
            $data = Language::where('status', 1)->get();
        }
        if (count($data) > 0) {
            $response = ["status" => 1, "message" => 'Language list.'];
            $response['data'] = $data;
            return response($response, 200);
        } else {
            $response = ["status" => 0, "message" => "Language list not found!"];
            $response['data'] = $data;
            return response($response, 200);
        }
    }

    // ----------------------- Quiz Section Start ------------------------------------------
    public function quizcategory($id = null)
    {
        if ($id != null) {
            $data = QuizMainCategory::with('languages:id,language_name')->where(['status' => 1, 'id' => $id])->get();
        } else {
            $data = QuizMainCategory::with('languages:id,language_name')->where('status', 1)->get();
        }
        if (count($data) > 0) {
            $response = ["status" => 1, "message" => 'Quiz Category list.'];
            $response['data'] = $data;
            return response($response, 200);
        } else {
            $response = ["status" => 0, "message" => "Quiz Category not found!"];
            $response['data'] = $data;
            return response($response, 200);
        }
    }


    public function quizsubcategory($id = null)
    {
        if ($id != null) {
            $data = QuizSubCategory::with(['languages:id,language_name', 'quizcategory:id,category_name'])->where(['status' => 1, 'id' => $id])->get();
        } else {
            $data = QuizSubCategory::with(['languages:id,language_name', 'quizcategory:id,category_name'])->where('status', 1)->get();
        }
        if (count($data) > 0) {
            $response = ["status" => 1, "message" => 'Quiz SubCategory list.'];
            $response['data'] = $data;
            return response($response, 200);
        } else {
            $response = ["status" => 0, "message" => "Quiz SubCategory not found!"];
            $response['data'] = $data;
            return response($response, 200);
        }
    }

    public function quizsub2category($id = null)
    {
        if ($id != null) {
            $data = QuizSub2Category::with(['languages:id,language_name', 'quizcategory:id,category_name', 'quizsubcategory:id,subcategory_name'])->where(['status' => 1, 'id' => $id])->get();
        } else {
            $data = QuizSub2Category::with(['languages:id,language_name', 'quizcategory:id,category_name', 'quizsubcategory:id,subcategory_name'])->where('status', 1)->get();
        }
        if (count($data) > 0) {
            $response = ["status" => 1, "message" => 'Quiz Sub2Category list.'];
            $response['data'] = $data;
            return response($response, 200);
        } else {
            $response = ["status" => 0, "message" => "Quiz Sub2Category not found!"];
            $response['data'] = $data;
            return response($response, 200);
        }
    }

    public function quizquestion($id = null)
    {
        if ($id != null) {
            $data = QuizQuestion::with(['languages:id,language_name', 'quizcategory:id,category_name', 'quizsubcategory:id,subcategory_name', 'quizsub2category:id,sub2category_name'])->where(['status' => 1, 'sub2category_id' => $id])->get();
        } else {
            $data = QuizQuestion::with(['languages:id,language_name', 'quizcategory:id,category_name', 'quizsubcategory:id,subcategory_name', 'quizsub2category:id,sub2category_name'])->where('status', 1)->get();
        }
        if (count($data) > 0) {
            $response = ["status" => 1, "message" => 'Quiz Question.'];
            $response['data'] = $data;
            return response($response, 200);
        } else {
            $response = ["status" => 0, "message" => "Quiz Question not found!"];
            $response['data'] = $data;
            return response($response, 200);
        }
    }


    // ------------------------Ebook Section Start ---------------------------------------

    public function ebookcategory($id = null)
    {
        if ($id != null) {
            $data = EbookMainCategory::with('languages:id,language_name')->where(['status' => 1, 'id' => $id])->get();
        } else {
            $data = EbookMainCategory::with('languages:id,language_name')->where('status', 1)->get();
        }
        if (count($data) > 0) {
            $response = ["status" => 1, "message" => 'Ebook Category.'];
            $response['data'] = $data;
            return response($response, 200);
        } else {
            $response = ["status" => 0, "message" => "Ebook Category not found!"];
            $response['data'] = $data;
            return response($response, 200);
        }
    }

    public function ebooksubcategory($id = null)
    {
        if ($id != null) {
            $data = EbookSubCategory::with(['languages:id,language_name', 'ebookcategory:id,category_name'])->where(['status' => 1, 'id' => $id])->get();
        } else {
            $data = EbookSubCategory::with(['languages:id,language_name', 'ebookcategory:id,category_name'])->where('status', 1)->get();
        }
        if (count($data) > 0) {
            $response = ["status" => 1, "message" => 'Ebook SubCategory.'];
            $response['data'] = $data;
            return response($response, 200);
        } else {
            $response = ["status" => 0, "message" => "Ebook SubCategory not found!"];
            $response['data'] = $data;
            return response($response, 200);
        }
    }

    public function ebooksub2category($id = null)
    {
        if ($id != null) {
            $data = EbookSub2Category::with(['languages:id,language_name', 'ebookcategory:id,category_name', 'ebooksubcategory:id,subcategory_name'])->where(['status' => 1, 'id' => $id])->get();
        } else {
            $data = EbookSub2Category::with(['languages:id,language_name', 'ebookcategory:id,category_name', 'ebooksubcategory:id,subcategory_name'])->where('status', 1)->get();
        }
        if (count($data) > 0) {
            $response = ["status" => 1, "message" => 'Ebook Sub2Category.'];
            $response['data'] = $data;
            return response($response, 200);
        } else {
            $response = ["status" => 0, "message" => "Ebook Sub2Category not found!"];
            $response['data'] = $data;
            return response($response, 200);
        }
    }

    public function ebook($id = null)
    {
        if ($id != null) {
            $data = Ebook::with(['languages:id,language_name', 'ebookcategory:id,category_name', 'ebooksubcategory:id,subcategory_name', 'ebooksub2category:id,sub2category_name'])->where(['status' => 1, 'id' => $id])->get();
        } else {
            $data = Ebook::with(['languages:id,language_name', 'ebookcategory:id,category_name', 'ebooksubcategory:id,subcategory_name', 'ebooksub2category:id,sub2category_name'])->where('status', 1)->get();
        }
        if (count($data) > 0) {
            $response = ["status" => 1, "message" => 'Ebook.'];
            $response['data'] = $data;
            $response['path'] = 'public/ebook/allebook/';
            return response($response, 200);
        } else {
            $response = ["status" => 0, "message" => "Ebook not found!"];
            $response['data'] = $data;
            return response($response, 200);
        }
    }

    // ------------------------- Daily News Section Start ------------------------------------

    public function dailycategory($id = null)
    {
        if ($id != null) {
            $data = DailyMainCategory::with('languages:id,language_name')->where(['status' => 1, 'id' => $id])->get();
        } else {
            $data = DailyMainCategory::with('languages:id,language_name')->where('status', 1)->get();
        }
        if (count($data) > 0) {
            $response = ["status" => 1, "message" => 'Daily News Category.'];
            $response['data'] = $data;
            return response($response, 200);
        } else {
            $response = ["status" => 0, "message" => "Daily News Category not found!"];
            $response['data'] = $data;
            return response($response, 200);
        }
    }

    public function dailynews($id = null)
    {
        if ($id != null) {
            $data = DailyNews::with(['languages:id,language_name', 'dailymaincategory:id,category_name'])->where(['status' => 1, 'id' => $id])->get();
        } else {
            $data = DailyNews::with(['languages:id,language_name', 'dailymaincategory:id,category_name'])->where('status', 1)->get();
        }
        if (count($data) > 0) {
            $response = ["status" => 1, "message" => 'Daily News.'];
            $response['data'] = $data;
            return response($response, 200);
        } else {
            $response = ["status" => 0, "message" => "Daily News not found!"];
            $response['data'] = $data;
            return response($response, 200);
        }
    }

    // ------------------------- Current Affair Section Start --------------------------------

    public function currentcategory($id = null)
    {
        if ($id != null) {
            $data = CurrentMainCategory::with('languages:id,language_name')->where(['status' => 1, 'id' => $id])->get();
        } else {
            $data = CurrentMainCategory::with('languages:id,language_name')->where('status', 1)->get();
        }
        if (count($data) > 0) {
            $response = ["status" => 1, "message" => 'Current Affair Category.'];
            $response['data'] = $data;
            return response($response, 200);
        } else {
            $response = ["status" => 0, "message" => "Current Affair Category not found!"];
            $response['data'] = $data;
            return response($response, 200);
        }
    }


    public function currentsubcategory($id = null)
    {
        if ($id != null) {
            $data = CurrentSubCategory::with(['languages:id,language_name', 'currentcategory:id,category_name'])->where(['status' => 1, 'id' => $id])->get();
        } else {
            $data = CurrentSubCategory::with(['languages:id,language_name', 'currentcategory:id,category_name'])->where('status', 1)->get();
        }
        if (count($data) > 0) {
            $response = ["status" => 1, "message" => 'Current Affair SubCategory.'];
            $response['data'] = $data;
            return response($response, 200);
        } else {
            $response = ["status" => 0, "message" => "Current Affair SubCategory not found!"];
            $response['data'] = $data;
            return response($response, 200);
        }
    }

    public function currentaffair($id = null)
    {
        if ($id != null) {
            $data = CurrentAffair::with(['languages:id,language_name', 'currentcategory:id,category_name', 'currentsubcategory:id,subcategory_name'])->where(['status' => 1, 'id' => $id])->get();
        } else {
            $data = CurrentAffair::with(['languages:id,language_name', 'currentcategory:id,category_name', 'currentsubcategory:id,subcategory_name'])->where('status', 1)->get();
        }
        if (count($data) > 0) {
            $response = ["status" => 1, "message" => 'Current Affair.'];
            $response['data'] = $data;
            return response($response, 200);
        } else {
            $response = ["status" => 0, "message" => "Current Affair not found!"];
            $response['data'] = $data;
            return response($response, 200);
        }
    }

    // --------------------------Question Answer Section Start -------------------------------

    public function questcategory($id = null)
    {
        if ($id != null) {
            $data = QuestMainCategory::with('languages:id,language_name')->where(['status' => 1, 'id' => $id])->get();
        } else {
            $data = QuestMainCategory::with('languages:id,language_name')->where('status', 1)->get();
        }
        if (count($data) > 0) {
            $response = ["status" => 1, "message" => 'Question Answer Category.'];
            $response['data'] = $data;
            return response($response, 200);
        } else {
            $response = ["status" => 0, "message" => "Question Answer Category not found!"];
            $response['data'] = $data;
            return response($response, 200);
        }
    }


    public function questsubcategory($id = null)
    {
        if ($id != null) {
            $data = QuestSubCategory::with(['languages:id,language_name', 'questcategory:id,category_name'])->where(['status' => 1, 'id' => $id])->get();
        } else {
            $data = QuestSubCategory::with(['languages:id,language_name', 'questcategory:id,category_name'])->where('status', 1)->get();
        }
        if (count($data) > 0) {
            $response = ["status" => 1, "message" => 'Question Answer SubCategory.'];
            $response['data'] = $data;
            return response($response, 200);
        } else {
            $response = ["status" => 0, "message" => "Question Answer SubCategory not found!"];
            $response['data'] = $data;
            return response($response, 200);
        }
    }

    public function questionAns($id = null)
    {
        if ($id != null) {
            $data = QuestionAnswer::with(['languages:id,language_name', 'questcategory:id,category_name', 'questsubcategory:id,subcategory_name'])->where(['status' => 1, 'id' => $id])->get();
        } else {
            $data = QuestionAnswer::with(['languages:id,language_name', 'questcategory:id,category_name', 'questsubcategory:id,subcategory_name'])->where('status', 1)->get();
        }
        if (count($data) > 0) {
            $response = ["status" => 1, "message" => 'Question Answer.'];
            $response['data'] = $data;
            return response($response, 200);
        } else {
            $response = ["status" => 0, "message" => "Question Answer not found!"];
            $response['data'] = $data;
            return response($response, 200);
        }
    }


     // ----------------------- Exam Prepration Section Start ------------------------------------------
     public function examcategory($id = null)
     {
         if ($id != null) {
             $data = ExamMainCategory::with('languages:id,language_name')->where(['status' => 1, 'id' => $id])->get();
         } else {
             $data = ExamMainCategory::with('languages:id,language_name')->where('status', 1)->get();
         }
         if (count($data) > 0) {
             $response = ["status" => 1, "message" => 'Exam Category list.'];
             $response['data'] = $data;
             return response($response, 200);
         } else {
             $response = ["status" => 0, "message" => "Exam Category not found!"];
             $response['data'] = $data;
             return response($response, 200);
         }
     }


     public function examsubcategory($id = null)
     {
         if ($id != null) {
             $data = ExamSubCategory::with(['languages:id,language_name', 'examcategory:id,category_name'])->where(['status' => 1, 'id' => $id])->get();
         } else {
             $data = ExamSubCategory::with(['languages:id,language_name', 'examcategory:id,category_name'])->where('status', 1)->get();
         }
         if (count($data) > 0) {
             $response = ["status" => 1, "message" => 'Exam SubCategory list.'];
             $response['data'] = $data;
             return response($response, 200);
         } else {
             $response = ["status" => 0, "message" => "Exam SubCategory not found!"];
             $response['data'] = $data;
             return response($response, 200);
         }
     }

     public function examsub2category($id = null)
     {
         if ($id != null) {
             $data = ExamSub2Category::with(['languages:id,language_name', 'examcategory:id,category_name', 'examsubcategory:id,subcategory_name'])->where(['status' => 1, 'id' => $id])->get();
         } else {
             $data = ExamSub2Category::with(['languages:id,language_name', 'examcategory:id,category_name', 'examsubcategory:id,subcategory_name'])->where('status', 1)->get();
         }
         if (count($data) > 0) {
             $response = ["status" => 1, "message" => 'Exam Sub2Category list.'];
             $response['data'] = $data;
             return response($response, 200);
         } else {
             $response = ["status" => 0, "message" => "Exam Sub2Category not found!"];
             $response['data'] = $data;
             return response($response, 200);
         }
     }

     public function examquestion($id = null)
     {
         if ($id != null) {
             $data = Exam::with(['languages:id,language_name', 'examcategory:id,category_name', 'examsubcategory:id,subcategory_name', 'examsub2category:id,sub2category_name'])->where('status', 1)->where('sub2category_id', $id)->get();
         } else {
             $data = Exam::with(['languages:id,language_name', 'examcategory:id,category_name', 'examsubcategory:id,subcategory_name', 'examsub2category:id,sub2category_name'])->where('status', 1)->get();
         }
         if (count($data) > 0) {
             $response = ["status" => 1, "message" => 'Exam Question.'];
             $response['data'] = $data;
             return response($response, 200);
         } else {
             $response = ["status" => 0, "message" => "Exam Question not found!"];
             $response['data'] = $data;
             return response($response, 200);
         }
     }

    public function banner()
    {
        $data = Banner::select('link','image','status')->get();

        if (count($data) > 0) {
            $response = ["status" => 1, "message" => 'Banners.'];
            $response['path'] = 'public/banners/image/';
            $response['data'] = $data;
            return response($response, 200);
        } else {
            $response = ["status" => 0, "message" => "Banners Not Found!"];
            $response['data'] = $data;
            return response($response, 200);
        }
    }
}
