<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\User;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

class AssignRoleController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function role_index()
    {
        $page_title = 'Assigned Role';
        $page_description = 'Some description for the page';
        $action = __FUNCTION__;
        $data = User::where('usertype', '!=', 'admin')->orderBy('id', 'desc')->get();

        return view('admin.assign_role.index', compact('page_title', 'page_description', 'data','action'));
    }

    public function role_create()
    {
        $page_title = 'Assign Role';
        $page_description = 'Some description for the page';
        $action = __FUNCTION__;

        return view('admin.assign_role.create', compact('page_title', 'page_description','action'));
    }

    public function store(Request $request)
    {
        $request->validate(
            [
                'username' => 'bail|required|string',
                'email' =>  'bail|required|string',
                'password' => 'bail|required|min:8',
                'usertype' => 'bail|required|string',

            ],
            [
                'username.required' => 'Please Enter name.',
                'email.required' => 'Please Enter email.',
                // 'mobile.digits' => 'Number should be 10 Digits.',
                // 'mobile.numeric' => 'Mobile number should be number not alphabet.',
                'password.required' => 'Password are Required Please enter.',
                'usertype.required' => 'Please assign Role.',
            ]
        );

        try {

            if (Auth::user()->status == 1) {

                // $input = $request->input();
                // unset($input['_token']);

                $newuser = new User();
                $newuser->name = $request->username;
                $newuser->email = $request->email;
                $newuser->password = Hash::make($request->password);
                $newuser->usertype = $request->usertype;
                $newuser->save();

                $response = [
                    'success' => true,
                    'type' => 'success',
                    'message' => 'Role Assigned'
                ];
                return response()->json($response, 200);
            } else {
                $response = [
                    'success' => false,
                    'type' => 'error',
                    'message' => 'You Are Not Eligible.'
                ];
                return response()->json($response, 200);
            }
        } catch (Exception $e) {
            $response = [
                'success' => false,
                'message' => $e->getMessage()
            ];
            return response()->json($response, 400);
        }
    }

    public function status(Request $request)
    {
        $request->validate([
            'id' => 'exists:users,id|numeric',
            'status' => 'boolean'
        ]);

        try {
            $user = User::find($request->id);
            $user->status = $request->status;
            $user->save();
            return response()->json([
                'status' => true,
                'type' => 'success',
                'message' => 'Status Updated.'
            ], 200);
        } catch (Exception $e) {
            return response()->json([
                'status' => false,
                'type' => 'error',
                'message' => $e->getMessage()
            ], 200);
        }
    }


    public function destroy(Request $request)
    {

        $data = User::where('id', $request->id)->first();

        if ($data) {
            $data->delete();
            $response = [
                'type' => 'success',
                'success' => true,
                'message' => 'Assign Role Removed',
            ];
            return response()->json($response, 200);
        }
        $response = [
            'success' => false,
            'type' => 'error',
            'message' => 'Something went wrong',
        ];
        return response()->json($response, 404);
    }
}
