<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Banner;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class BannerController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function banners_index()
    {
        $page_title = 'Banners';
        $page_description = 'Some description for the page';
        $action = __FUNCTION__;
        $data = Banner::orderBy('id', 'desc')->get();
        return view('admin.banner.index', compact('page_title', 'page_description', 'action', 'data'));
    }


    public function store(Request $request)
    {
        $request->validate(
            [

                'link' => 'bail|required|string',
                'image' => 'bail|required|image|mimes:jpg,png,jpeg,gif|max:2048',
            ],
            [

                'link.required' => 'Please Enter Link.',
                'image.required' => 'Please Upload image.',
            ]
        );

        try {
            if (Auth::user()->status == 1) {

                $input = $request->input();
                unset($input['_token']);

                if ($request->hasfile('image')) {

                    $destinationPath = public_path('/banners/image/');

                    $image = $request->image;
                    $fileName = 'banner-' . uniqid() . '.' . $image->extension();
                    $fileName = str_replace(" ", "-", $fileName);


                    if (!is_dir($destinationPath)) {
                        mkdir($destinationPath, 0777, TRUE);
                        @chmod($destinationPath, 0777);
                    }
                    $image->move($destinationPath, $fileName);
                    $input['image'] = $fileName;
                }

                Banner::create($input);


                $response = [
                    'success' => true,
                    'type' => 'success',
                    'message' => 'Banner Added'
                ];
                return response()->json($response, 200);
            } else {
                $response = [
                    'success' => false,
                    'type' => 'error',
                    'message' => 'You Are Not Eligible.'
                ];
                return response()->json($response, 200);
            }
        } catch (Exception $e) {
            $response = [
                'success' => false,
                'type' => 'error',
                'message' => $e->getMessage()
            ];
            return response()->json($response, 400);
        }
    }



    public function status(Request $request)
    {
        $request->validate([
            'id' => 'exists:banners,id|numeric',
            'status' => 'boolean'
        ]);

        try {
            $cat = Banner::find($request->id);
            $cat->status = $request->status;
            $cat->save();
            return response()->json([
                'status' => true,
                'type' => 'success',
                'message' => 'Status Updated.'
            ], 200);
        } catch (Exception $e) {
            return response()->json([
                'status' => false,
                'type' => 'error',
                'message' => $e->getMessage()
            ], 200);
        }
    }

    public function destroy(Request $request)
    {

        $destinationPath = public_path('/banners/image/');
        $data = Banner::where('id', $request->id)->first();
        // dd($data);
        try {
            if (!empty($data)) {
                unlink($destinationPath . $data->image);
            }
        } catch (Exception $e) {
            echo $e->getMessage();
        }

        if ($data) {
            $data->delete();
            $response = [
                'type' => 'success',
                'success' => true,
                'message' => 'Banner Removed',
            ];
            return response()->json($response, 200);
        }
        $response = [
            'success' => false,
            'type' => 'error',
            'message' => 'Something went wrong',
        ];
        return response()->json($response, 404);
    }
}
