<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

class ChangePassController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function password_update()
    {
        $data = Auth::user();
        $page_title = "Update Password";
        $page_description = "Update";
        $action = __FUNCTION__;
        return view('admin.changepassword.index', compact('data','page_title','page_description','action'));
    }


    public function change_password(Request $request)
    {

        $data = Auth::user();
        $user = User::find($data->id);
        $action = __FUNCTION__;

        // dd($request);
        $request->validate([
            'userid' => ['exists:users,id'],
            'current_pass' => ['required', 'string', 'min:8'],
            'password' => ['required', 'string', 'min:8', 'confirmed']
        ]);

        $current_passStatus = Hash::check($request->current_pass, $data->password);

        // dd($current_passStatus);
        if ($current_passStatus) {
            $val =  $user->update([
                'password' => Hash::make($request->password)
            ]);

            // dd($val);
            return redirect()->back()->with('success', 'Password Updated');
        } else {
            return redirect()->back()->with('fails', 'Current Password does not match old password');
        }


        return view('admin.changepassword.index', compact('data','action'));
    }
}
