<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\DailyMainCategory;
use App\Models\Language;
use Illuminate\Support\Facades\Auth;
use Exception;
use Illuminate\Http\Request;

class DailyMainCategoryController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function dailymain_index()
    {
        $page_title = 'Main Category';
        $page_description = 'Some description for the page';
        $action = __FUNCTION__;
        $data = DailyMainCategory::with('languages')->orderBy('id', 'desc')->get();
        $languages = Language::where('status',1)->get();
        return view('admin.dailynews.category', compact('page_title', 'page_description', 'action', 'data','languages'));
    }


    public function store(Request $request)
    {
        $request->validate(
            [
                'language_id' => 'bail|required|exists:languages,id|numeric',
                'category_name' => 'bail|required|string',
                'image' => 'bail|nullable|image|mimes:jpg,png,jpeg,gif|max:2048',
            ],
            [
                'language_id.required' => 'Please Select language.',
                'category_name.required' => 'Please Enter Category Name.',
            ]
        );

        try {
            if (Auth::user()->status == 1) {

                $input = $request->input();
                unset($input['_token']);

                if ($request->hasfile('image')) {

                    $destinationPath = public_path('/dailynews/maincategory/');

                    $image = $request->image;
                    $fileName = ' newsMain-' . uniqid() . '.' . $image->extension();
                    $fileName = str_replace(" ", "-", $fileName);


                    if (!is_dir($destinationPath)) {
                        mkdir($destinationPath, 0777, TRUE);
                        @chmod($destinationPath, 0777);
                    }
                    $image->move($destinationPath, $fileName);
                    $input['image'] = $fileName;
                }

                DailyMainCategory::create($input);


                $response = [
                    'success' => true,
                    'type' => 'success',
                    'message' => 'Category Added'
                ];
                return response()->json($response, 200);
            } else {
                $response = [
                    'success' => false,
                    'type' => 'error',
                    'message' => 'You Are Not Eligible.'
                ];
                return response()->json($response, 200);
            }
        } catch (Exception $e) {
            $response = [
                'success' => false,
                'type' => 'error',
                'message' => $e->getMessage()
            ];
            return response()->json($response, 400);
        }
    }


    public function update(Request $request)
    {
        $request->validate([
            'id' => 'bail|exists:daily_main_categories,id|numeric',
        ]);

        try {
            if (Auth::user()->status == 1) {

                $input = $request->input();
                unset($input['_token']);
                // unset($input['_method']);
                if ($request->hasfile('image')) {

                    $destinationPath = public_path('/dailynews/maincategory/');
                    $data = DailyMainCategory::where('id', $request->id)->first();
                    // dd($data);
                    try {
                        if (!empty($data)) {
                            unlink($destinationPath . $data->image);
                        }
                    } catch (Exception $e) {
                        echo $e->getMessage();
                    }

                    $image = $request->image;
                    $fileName = ' newsMain-' . uniqid() . '.' . $image->extension();
                    $fileName = str_replace(" ", "-", $fileName);


                    if (!is_dir($destinationPath)) {
                        mkdir($destinationPath, 0777, TRUE);
                        @chmod($destinationPath, 0777);
                    }
                    $image->move($destinationPath, $fileName);
                    $input['image'] = $fileName;
                }
                $id = $request->id;
                DailyMainCategory::where("id", $id)->update($input);
                $response = [
                    'success' => true,
                    'type' => 'success',
                    'message' => 'Category Updated'
                ];
                return response()->json($response, 200);
            } else {
                $response = [
                    'success' => false,
                    'type' => 'error',
                    'message' => 'You Are Not Eligible.'
                ];
                return response()->json($response, 200);
            }
        } catch (Exception $e) {
            $response = [
                'success' => false,
                'type' => 'error',
                'message' => $e->getMessage()
            ];
            return response()->json($response, 400);
        }
    }

    public function status(Request $request)
    {
        $request->validate([
            'id' => 'exists:daily_main_categories,id|numeric',
            'status' => 'boolean'
        ]);

        try {
            $cat = DailyMainCategory::find($request->id);
            $cat->status = $request->status;
            $cat->save();
            return response()->json([
                'status' => true,
                'type' => 'success',
                'message' => 'Status Updated.'
            ], 200);
        } catch (Exception $e) {
            return response()->json([
                'status' => false,
                'type' => 'error',
                'message' => $e->getMessage()
            ], 200);
        }
    }

    public function destroy(Request $request)
    {

        $destinationPath = public_path('/dailynews/maincategory/');
        $data = DailyMainCategory::where('id', $request->id)->first();
       // dd($data);
        try {
            if (!empty($data)) {
                unlink($destinationPath . $data->image);
            }
        } catch (Exception $e) {
            echo $e->getMessage();
        }

        if ($data) {
            $data->delete();
            $response = [
                'type' => 'success',
                'success' => true,
                'message' => 'Category Removed',
            ];
            return response()->json($response, 200);
        }
        $response = [
            'success' => false,
            'type' => 'error',
            'message' => 'Something went wrong',
        ];
        return response()->json($response, 404);
    }
}
