<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\DailyMainCategory;
use App\Models\DailyNews;
use App\Models\Language;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class DailyNewsController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function dailynews_index()
    {
        $page_title = 'See Daily News';
        $page_description = 'Some description for the page';
        $action = __FUNCTION__;
        $data = DailyNews::with(['languages', 'dailymaincategory'])->orderBy('id', 'desc')->get();
        // $languages = Language::where('status', 1)->get();
        // $maincategory = DailyMainCategory::where('status', 1)->get();
        return view('admin.dailynews.index', compact('page_title', 'page_description', 'action', 'data'));
    }

    public function dailynews_create()
    {
        $page_title = 'Add Daily news';
        $page_description = 'Some description for the page';
        $action = __FUNCTION__;
        $languages = Language::where('status', 1)->get();
        $maincategory = DailyMainCategory::where('status', 1)->get();

        return view('admin.dailynews.create', compact('page_title', 'page_description', 'action', 'languages', 'maincategory'));
    }

    public function store(Request $request)
    {
        $request->validate(
            [
                'language_id' => 'bail|required|exists:languages,id|numeric',
                'category_id' => 'bail|required|exists:daily_main_categories,id|numeric',
                'title' =>  'bail|required|string',
                'description' =>  'bail|required|string',
                'image' => 'bail|nullable|image|mimes:jpg,png,jpeg,gif',
            ],
            [
                'language_id.required' => 'Please Select language.',
                'category_id.required' => 'Please Select Category.',
                'title.required' => 'Please Enter title.',
                'description.required' => 'Please Give Description.',
            ]
        );

        try {
            if (Auth::user()->status == 1) {

                $input = $request->input();
                unset($input['_token']);

                if ($request->hasfile('image')) {

                    $destinationPath = public_path('/dailynews/banner/');
                    $image = $request->image;
                    $fileName = 'NewsIMG-' . uniqid() . '.' . $image->extension();
                    $fileName = str_replace(" ", "-", $fileName);


                    if (!is_dir($destinationPath)) {
                        mkdir($destinationPath, 0777, TRUE);
                        @chmod($destinationPath, 0777);
                    }
                    $image->move($destinationPath, $fileName);
                    $input['image'] = $fileName;
                }

                DailyNews::create($input);
                $response = [
                    'success' => true,
                    'type' => 'success',
                    'message' => 'New News Added'
                ];
                return response()->json($response, 200);
            } else {
                $response = [
                    'success' => false,
                    'type' => 'error',
                    'message' => 'You Are Not Eligible.'
                ];
                return response()->json($response, 200);
            }
        } catch (Exception $e) {
            $response = [
                'success' => false,
                'type' => 'error',
                'message' => $e->getMessage()
            ];
            return response()->json($response, 400);
        }
    }

    public function dailynews_edit(Request $request)
    {
        $data = DailyNews::find($request->id);
        $page_title = 'Edit News';
        $page_description = 'Some description for the page';
        $action = __FUNCTION__;
        $languages = Language::where('status', 1)->get();
        $maincategory = DailyMainCategory::where('status', 1)->get();

        return view('admin.dailynews.update', compact('page_title', 'page_description', 'action', 'languages', 'maincategory', 'data'));
    }
    public function update(Request $request)
    {
        $request->validate([
            'id' => 'bail|exists:daily_news,id|numeric',
        ]);

        try {
            if (Auth::user()->status == 1) {

                $input = $request->input();
                unset($input['_token']);
                // unset($input['_method']);
                if ($request->hasfile('image')) {

                    $destinationPath = public_path('/dailynews/banner/');
                    $data = DailyNews::where('id', $request->id)->first();
                    // dd($data);
                    try {
                        if (!empty($data)) {
                            unlink($destinationPath . $data->image);
                        }
                    } catch (Exception $e) {
                        echo $e->getMessage();
                    }

                    $image = $request->image;
                    $fileName = 'NewsIMG-' . uniqid() . '.' . $image->extension();
                    $fileName = str_replace(" ", "-", $fileName);


                    if (!is_dir($destinationPath)) {
                        mkdir($destinationPath, 0777, TRUE);
                        @chmod($destinationPath, 0777);
                    }
                    $image->move($destinationPath, $fileName);
                    $input['image'] = $fileName;
                }


                $id = $request->id;
                DailyNews::where("id", $id)->update($input);
                $response = [
                    'success' => true,
                    'type' => 'success',
                    'message' => 'News Updated'
                ];
                return response()->json($response, 200);
            } else {
                $response = [
                    'success' => false,
                    'type' => 'error',
                    'message' => 'You Are Not Eligible.'
                ];
                return response()->json($response, 200);
            }
        } catch (Exception $e) {
            $response = [
                'success' => false,
                'type' => 'error',
                'message' => $e->getMessage()
            ];
            return response()->json($response, 400);
        }
    }

    public function status(Request $request)
    {
        $request->validate([
            'id' => 'exists:daily_news,id|numeric',
            'status' => 'boolean'
        ]);

        try {
            $cat = DailyNews::find($request->id);
            $cat->status = $request->status;
            $cat->save();
            return response()->json([
                'status' => true,
                'type' => 'success',
                'message' => 'Status Updated.'
            ], 200);
        } catch (Exception $e) {
            return response()->json([
                'status' => false,
                'type' => 'error',
                'message' => $e->getMessage()
            ], 200);
        }
    }

    public function destroy(Request $request)
    {

        $destinationPath = public_path('/dailynews/banner/');
        $data = DailyNews::where('id', $request->id)->first();
        // dd($data);
        // try {
        //     if (!empty($data)) {
        //         unlink($destinationPath . $data->image);
        //     }
        // } catch (Exception $e) {
        //     echo $e->getMessage();
        // }

        if ($data) {
            $data->delete();
            $response = [
                'type' => 'success',
                'success' => true,
                'message' => 'News Removed',
            ];
            return response()->json($response, 200);
        }
        $response = [
            'success' => false,
            'type' => 'error',
            'message' => 'Something went wrong',
        ];
        return response()->json($response, 404);
    }
}
