<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Banner;
use App\Models\CurrentAffair;
use App\Models\DailyNews;
use App\Models\Ebook;
use App\Models\Language;
use App\Models\QuestionAnswer;
use App\Models\QuizQuestion;
use App\Models\User;
use Illuminate\Http\Request;

class DashboardController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index()
    {
        $page_title = 'Dashboard';
        $page_description = 'Some description for the page';
        $action = __FUNCTION__;

        $language = Language::where('status',1)->count();
        $quiz = QuizQuestion::where('status',1)->count();
        $ebook = Ebook::where('status',1)->count();
        $current = CurrentAffair::where('status',1)->count();
        $dailynews = DailyNews::where('status',1)->count();
        $question = QuestionAnswer::where('status',1)->count();
        $banner = Banner::where('status',1)->count();
        $usercount = User::count();

        return view('admin.dashboard.index', compact('page_title', 'page_description','action','language','ebook','quiz','current','dailynews','question','banner','usercount'));
    }
}
