<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Ebook;
use App\Models\EbookSub2Category;
use App\Models\Language;
use App\Models\EbookMainCategory;
use App\Models\EbookSubCategory;
use Illuminate\Support\Facades\Auth;
use Exception;
use Illuminate\Http\Request;

class EbookController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function ebook_index()
    {
        $page_title = 'See All Ebook';
        $page_description = 'Some description for the page';
        $action = __FUNCTION__;
        $data = Ebook::with(['languages', 'ebookcategory', 'ebooksubcategory', 'ebooksub2category'])->orderBy('id', 'desc')->get();
        $languages = Language::where('status', 1)->get();
        $maincategory = EbookMainCategory::where('status', 1)->get();
        $subcategory = EbookSubCategory::where('status', 1)->get();
        $sub2category = EbookSub2Category::where('status', 1)->get();
        return view('admin.ebook.index', compact('page_title', 'page_description', 'action', 'data', 'languages', 'maincategory', 'subcategory', 'sub2category'));
    }

    public function ebook_create()
    {
        $page_title = 'Add Ebook';
        $page_description = 'Some description for the page';
        $action = __FUNCTION__;
        $languages = Language::where('status', 1)->get();
        $maincategory = EbookMainCategory::where('status', 1)->get();
        $subcategory = EbookSubCategory::where('status', 1)->get();
        $sub2category = EbookSub2Category::where('status', 1)->get();
        return view('admin.ebook.create', compact('page_title', 'page_description', 'action', 'languages', 'maincategory', 'subcategory', 'sub2category'));
    }

    public function store(Request $request)
    {
        $request->validate(
            [
                'language_id' => 'bail|required|exists:languages,id|numeric',
                'category_id' => 'bail|required|exists:ebook_main_categories,id|numeric',
                'subcategory_id' => 'bail|required|exists:ebook_sub_categories,id|numeric',
                'sub2category_id' => 'bail|required|exists:ebook_sub2_categories,id|numeric',
                'title' =>  'bail|required|string',
                'ebookpdf' =>  'bail|required|mimes:docx,pdf',
                'image' => 'bail|nullable|image|mimes:jpg,png,jpeg,gif',
            ],
            [
                'language_id.required' => 'Please Select language.',
                'category_id.required' => 'Please Select Category.',
                'subcategory_id.required' => 'Please Select Sub Category.',
                'sub2category_id.required' => 'Please Select Sub 2 Category.',
                'title.required' => 'Please Enter ebook title.',
                'ebookpdf.required' => 'Please upload pdf.',
            ]
        );

        try {
            if (Auth::user()->status == 1) {

                $input = $request->input();
                unset($input['_token']);

                if ($request->hasfile('image')) {

                    $destinationPath = public_path('/ebook/allebookimage/');

                    $image = $request->image;
                    $fileName = 'EbookIMG-' . uniqid() . '.' . $image->extension();
                    $fileName = str_replace(" ", "-", $fileName);


                    if (!is_dir($destinationPath)) {
                        mkdir($destinationPath, 0777, TRUE);
                        @chmod($destinationPath, 0777);
                    }
                    $image->move($destinationPath, $fileName);
                    $input['image'] = $fileName;
                }

                if ($request->hasfile('ebookpdf')) {
                    $destinationPath = public_path('/ebook/allebook/');

                    $pdf = $request->ebookpdf;
                    $fileName = 'Ebook-' . uniqid() . '.' . $pdf->extension();
                    $fileName = str_replace(" ", "-", $fileName);

                    if (!is_dir($destinationPath)) {
                        mkdir($destinationPath, 0777, TRUE);
                        @chmod($destinationPath, 0777);
                    }

                    $pdf->move($destinationPath, $fileName);
                    $input['ebookpdf'] = $fileName;
                }

                Ebook::create($input);
                $response = [
                    'success' => true,
                    'type' => 'success',
                    'message' => 'New Ebook Added'
                ];
                return response()->json($response, 200);
            } else {
                $response = [
                    'success' => false,
                    'type' => 'error',
                    'message' => 'You Are Not Eligible.'
                ];
                return response()->json($response, 200);
            }
        } catch (Exception $e) {
            $response = [
                'success' => false,
                'type' => 'error',
                'message' => $e->getMessage()
            ];
            return response()->json($response, 400);
        }
    }




    public function ebook_edit(Request $request)
    {
        $data = Ebook::find($request->id);
        $page_title = 'Edit Ebook';
        $page_description = 'Some description for the page';
        $action = __FUNCTION__;
        $languages = Language::where('status', 1)->get();
        $maincategory = EbookMainCategory::where('status', 1)->get();
        $subcategory = EbookSubCategory::where('status', 1)->get();
        $sub2category = EbookSub2Category::where('status', 1)->get();
        return view('admin.ebook.update', compact('page_title', 'page_description', 'action', 'languages', 'maincategory', 'subcategory', 'sub2category', 'data'));
    }
    public function update(Request $request)
    {
        $request->validate([
            'id' => 'bail|exists:ebooks,id|numeric',
        ]);

        try {
            if (Auth::user()->status == 1) {

                $input = $request->input();
                unset($input['_token']);
                // unset($input['_method']);
                if ($request->hasfile('image')) {

                    $destinationPath = public_path('/ebook/allebookimage/');
                    $data = Ebook::where('id', $request->id)->first();
                    // dd($data);
                    try {
                        if (!empty($data)) {
                            unlink($destinationPath . $data->image);
                        }
                    } catch (Exception $e) {
                        echo $e->getMessage();
                    }

                    $image = $request->image;
                    $fileName = 'EbookIMG-' . uniqid() . '.' . $image->extension();
                    $fileName = str_replace(" ", "-", $fileName);


                    if (!is_dir($destinationPath)) {
                        mkdir($destinationPath, 0777, TRUE);
                        @chmod($destinationPath, 0777);
                    }
                    $image->move($destinationPath, $fileName);
                    $input['image'] = $fileName;
                }

                if ($request->hasfile('ebookpdf')) {

                    $destinationPath = public_path('/ebook/allebook/');
                    $data = Ebook::where('id', $request->id)->first();
                    // dd($data);
                    try {
                        if (!empty($data)) {
                            unlink($destinationPath . $data->image);
                        }
                    } catch (Exception $e) {
                        echo $e->getMessage();
                    }

                    $pdf = $request->ebookpdf;
                    $fileName = 'Ebook-' . uniqid() . '.' . $pdf->extension();
                    $fileName = str_replace(" ", "-", $fileName);


                    if (!is_dir($destinationPath)) {
                        mkdir($destinationPath, 0777, TRUE);
                        @chmod($destinationPath, 0777);
                    }
                    $pdf->move($destinationPath, $fileName);
                    $input['ebookpdf'] = $fileName;
                }
                $id = $request->id;
                Ebook::where("id", $id)->update($input);
                $response = [
                    'success' => true,
                    'type' => 'success',
                    'message' => 'Ebook Updated'
                ];
                return response()->json($response, 200);
            } else {
                $response = [
                    'success' => false,
                    'type' => 'error',
                    'message' => 'You Are Not Eligible.'
                ];
                return response()->json($response, 200);
            }
        } catch (Exception $e) {
            $response = [
                'success' => false,
                'type' => 'error',
                'message' => $e->getMessage()
            ];
            return response()->json($response, 400);
        }
    }

    public function status(Request $request)
    {
        $request->validate([
            'id' => 'exists:ebooks,id|numeric',
            'status' => 'boolean'
        ]);

        try {
            $cat = Ebook::find($request->id);
            $cat->status = $request->status;
            $cat->save();
            return response()->json([
                'status' => true,
                'type' => 'success',
                'message' => 'Status Updated.'
            ], 200);
        } catch (Exception $e) {
            return response()->json([
                'status' => false,
                'type' => 'error',
                'message' => $e->getMessage()
            ], 200);
        }
    }

    public function destroy(Request $request)
    {

        $destinationPathIMG = public_path('/ebook/allebookimage/');
        $destinationPath = public_path('/ebook/allebook/');
        $data = Ebook::where('id', $request->id)->first();
        // dd($data);
        // try {
        //     if (!empty($data)) {
        //         unlink($destinationPathIMG . $data->image);
        //     }
        // } catch (Exception $e) {
        //     echo $e->getMessage();
        // }
        try {
            if (!empty($data)) {
                unlink($destinationPath . $data->ebookpdf);
            }
        } catch (Exception $e) {
            echo $e->getMessage();
        }

        if ($data) {
            $data->delete();
            $response = [
                'type' => 'success',
                'success' => true,
                'message' => 'Ebook Removed',
            ];
            return response()->json($response, 200);
        }
        $response = [
            'success' => false,
            'type' => 'error',
            'message' => 'Something went wrong',
        ];
        return response()->json($response, 404);
    }
}
