<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Exam;
use App\Models\ExamMainCategory;
use App\Models\ExamSub2Category;
use App\Models\ExamSubCategory;
use App\Models\Language;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class ExamController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function exam_index()
    {
        $page_title = 'See All Exam Question';
        $page_description = 'Some description for the page';
        $action = __FUNCTION__;
        $data = Exam::with(['languages','examcategory','examsubcategory','examsub2category'])->orderBy('id', 'desc')->get();
        $languages = Language::where('status',1)->get();
        $maincategory = ExamMainCategory::where('status',1)->get();
        $subcategory = ExamSubCategory::where('status',1)->get();
        $sub2category = ExamSub2Category::where('status',1)->get();
        return view('admin.exam.index', compact('page_title', 'page_description', 'action', 'data','languages','maincategory','subcategory','sub2category'));
    }

    public function exam_create()
    {
        $page_title = 'Add Exam Question';
        $page_description = 'Some description for the page';
        $action = __FUNCTION__;
        $languages = Language::where('status',1)->get();
        $maincategory = ExamMainCategory::where('status',1)->get();
        $subcategory = ExamSubCategory::where('status',1)->get();
        $sub2category = ExamSub2Category::where('status',1)->get();
        return view('admin.exam.create', compact('page_title', 'page_description', 'action','languages','maincategory','subcategory','sub2category'));
    }

    public function store(Request $request)
    {
        $request->validate(
            [
                'language_id' => 'bail|required|exists:languages,id|numeric',
                'category_id' => 'bail|required|exists:exam_main_categories,id|numeric',
                'subcategory_id' => 'bail|required|exists:exam_sub_categories,id|numeric',
                'sub2category_id' => 'bail|required|exists:exam_sub2_categories,id|numeric',
                'question' =>  'bail|required|string',
                'one' =>  'bail|required|string',
                'two' =>  'bail|required|string',
                'three' =>  'bail|required|string',
                'four' =>  'bail|required|string',
                'answer' =>  'bail|required|string',
                'image' => 'bail|nullable|image|mimes:jpg,png,jpeg,gif|max:2048',
            ],
            [
                'language_id.required' => 'Please Select language.',
                'category_id.required' => 'Please Select Category.',
                'subcategory_id.required' => 'Please Select Sub Category.',
                'sub2category_id.required' => 'Please Select Sub 2 Category.',
                'question.required' => 'Please Enter Question.',
                'one.required' => 'Please Enter Option 1st.',
                'two.required' => 'Please Enter Option 2nd.',
                'three.required' => 'Please Enter Option 3rd.',
                'four.required' => 'Please Enter Option 4th.',
                'answer.required' => 'Please select Answer.',
            ]
        );

        try {
            if (Auth::user()->status == 1) {

                $input = $request->input();
                unset($input['_token']);

                if ($request->hasfile('image')) {

                    $destinationPath = public_path('/exam/question/');

                    $image = $request->image;
                    $fileName = 'Exam-' . uniqid() . '.' . $image->extension();
                    $fileName = str_replace(" ", "-", $fileName);


                    if (!is_dir($destinationPath)) {
                        mkdir($destinationPath, 0777, TRUE);
                        @chmod($destinationPath, 0777);
                    }
                    $image->move($destinationPath, $fileName);
                    $input['image'] = $fileName;
                }

                Exam::create($input);


                $response = [
                    'success' => true,
                    'type' => 'success',
                    'message' => 'New Question Added'
                ];
                return response()->json($response, 200);
            } else {
                $response = [
                    'success' => false,
                    'type' => 'error',
                    'message' => 'You Are Not Eligible.'
                ];
                return response()->json($response, 200);
            }
        } catch (Exception $e) {
            $response = [
                'success' => false,
                'type' => 'error',
                'message' => $e->getMessage()
            ];
            return response()->json($response, 400);
        }
    }




    public function exam_edit(Request $request)
    {
        $data = Exam::find($request->id);
        $page_title = 'Edit Exam Question';
        $page_description = 'Some description for the page';
        $action = __FUNCTION__;
        $languages = Language::where('status',1)->get();
        $maincategory = ExamMainCategory::where('status',1)->get();
        $subcategory = ExamSubCategory::where('status',1)->get();
        $sub2category = ExamSub2Category::where('status',1)->get();
        return view('admin.exam.update', compact('page_title', 'page_description', 'action','languages','maincategory','subcategory','sub2category','data'));
    }
    public function update(Request $request)
    {
        $request->validate([
            'id' => 'bail|exists:exams,id|numeric',
        ]);

        try {
            if (Auth::user()->status == 1) {

                $input = $request->input();
                unset($input['_token']);
                // unset($input['_method']);
                if ($request->hasfile('image')) {

                    $destinationPath = public_path('/exam/question/');
                    $data = Exam::where('id', $request->id)->first();
                    // dd($data);
                    try {
                        if (!empty($data)) {
                            unlink($destinationPath . $data->image);
                        }
                    } catch (Exception $e) {
                        echo $e->getMessage();
                    }

                    $image = $request->image;
                    $fileName = 'Exam-' . uniqid() . '.' . $image->extension();
                    $fileName = str_replace(" ", "-", $fileName);


                    if (!is_dir($destinationPath)) {
                        mkdir($destinationPath, 0777, TRUE);
                        @chmod($destinationPath, 0777);
                    }
                    $image->move($destinationPath, $fileName);
                    $input['image'] = $fileName;
                }
                $id = $request->id;
                Exam::where("id", $id)->update($input);
                $response = [
                    'success' => true,
                    'type' => 'success',
                    'message' => 'Question Updated'
                ];
                return response()->json($response, 200);
            } else {
                $response = [
                    'success' => false,
                    'type' => 'error',
                    'message' => 'You Are Not Eligible.'
                ];
                return response()->json($response, 200);
            }
        } catch (Exception $e) {
            $response = [
                'success' => false,
                'type' => 'error',
                'message' => $e->getMessage()
            ];
            return response()->json($response, 400);
        }
    }

    public function status(Request $request)
    {
        $request->validate([
            'id' => 'exists:exams,id|numeric',
            'status' => 'boolean'
        ]);

        try {
            $cat = Exam::find($request->id);
            $cat->status = $request->status;
            $cat->save();
            return response()->json([
                'status' => true,
                'type' => 'success',
                'message' => 'Status Updated.'
            ], 200);
        } catch (Exception $e) {
            return response()->json([
                'status' => false,
                'type' => 'error',
                'message' => $e->getMessage()
            ], 200);
        }
    }

    public function destroy(Request $request)
    {

        // $destinationPath = public_path('/exam/question/');
        $data = Exam::where('id', $request->id)->first();
        // dd($data);
        // try {
        //     if (!empty($data)) {
        //         unlink($destinationPath . $data->image);
        //     }
        // } catch (Exception $e) {
        //     echo $e->getMessage();
        // }

        if ($data) {
            $data->delete();
            $response = [
                'type' => 'success',
                'success' => true,
                'message' => 'Question Removed',
            ];
            return response()->json($response, 200);
        }
        $response = [
            'success' => false,
            'type' => 'error',
            'message' => 'Something went wrong',
        ];
        return response()->json($response, 404);
    }
}
