<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\ExamMainCategory;
use App\Models\ExamSub2Category;
use App\Models\ExamSubCategory;
use App\Models\Language;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class ExamSub2CategoryController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function examsub2_index()
    {
        $page_title = 'Sub 2 Category';
        $page_description = 'Some description for the page';
        $action = __FUNCTION__;
        $data = ExamSub2Category::with(['languages','examcategory','examsubcategory'])->orderBy('id', 'desc')->get();
        $languages = Language::where('status',1)->get();
        $maincategory = ExamMainCategory::where('status',1)->get();
        $subcategory = ExamSubCategory::where('status',1)->get();
        return view('admin.exam.sub2category', compact('page_title', 'page_description', 'action', 'data','languages','maincategory','subcategory'));
    }



    public function store(Request $request)
    {
        $request->validate(
            [
                'language_id' => 'bail|required|exists:languages,id|numeric',
                'category_id' => 'bail|required|exists:exam_main_categories,id|numeric',
                'subcategory_id' => 'bail|required|exists:exam_sub_categories,id|numeric',
                'sub2category_name' => 'bail|required|string',
                'image' => 'bail|nullable|image|mimes:jpg,png,jpeg,gif|max:2048',
            ],
            [
                'language_id.required' => 'Please Select language.',
                'category_id.required' => 'Please Select Category.',
                'subcategory_id.required' => 'Please Select Sub Category.',
                'sub2category_name.required' => 'Please Enter Sub Category Name.',
            ]
        );

        try {
            if (Auth::user()->status == 1) {

                $input = $request->input();
                unset($input['_token']);

                if ($request->hasfile('image')) {

                    $destinationPath = public_path('/exam/sub2category/');

                    $image = $request->image;
                    $fileName = 'examSub2-' . uniqid() . '.' . $image->extension();
                    $fileName = str_replace(" ", "-", $fileName);


                    if (!is_dir($destinationPath)) {
                        mkdir($destinationPath, 0777, TRUE);
                        @chmod($destinationPath, 0777);
                    }
                    $image->move($destinationPath, $fileName);
                    $input['image'] = $fileName;
                }

                ExamSub2Category::create($input);


                $response = [
                    'success' => true,
                    'type' => 'success',
                    'message' => 'Sub 2 Category Added'
                ];
                return response()->json($response, 200);
            } else {
                $response = [
                    'success' => false,
                    'type' => 'error',
                    'message' => 'You Are Not Eligible.'
                ];
                return response()->json($response, 200);
            }
        } catch (Exception $e) {
            $response = [
                'success' => false,
                'type' => 'error',
                'message' => $e->getMessage()
            ];
            return response()->json($response, 400);
        }
    }


    public function update(Request $request)
    {
        $request->validate([
            'id' => 'exists:exam_sub2_categories,id|numeric',
        ]);

        try {
            if (Auth::user()->status == 1) {

                $input = $request->input();
                unset($input['_token']);
                // unset($input['_method']);
                if ($request->hasfile('image')) {

                    $destinationPath = public_path('/exam/sub2category/');
                    $data = ExamSub2Category::where('id', $request->id)->first();
                    // dd($data);
                    try {
                        if (!empty($data)) {
                            unlink($destinationPath . $data->image);
                        }
                    } catch (Exception $e) {
                        echo $e->getMessage();
                    }

                    $image = $request->image;
                    $fileName = 'examSub2-' . uniqid() . '.' . $image->extension();
                    $fileName = str_replace(" ", "-", $fileName);


                    if (!is_dir($destinationPath)) {
                        mkdir($destinationPath, 0777, TRUE);
                        @chmod($destinationPath, 0777);
                    }
                    $image->move($destinationPath, $fileName);
                    $input['image'] = $fileName;
                }
                $id = $request->id;
                ExamSub2Category::where("id", $id)->update($input);
                $response = [
                    'success' => true,
                    'type' => 'success',
                    'message' => ' Sub 2 Category Updated'
                ];
                return response()->json($response, 200);
            } else {
                $response = [
                    'success' => false,
                    'type' => 'error',
                    'message' => 'You Are Not Eligible.'
                ];
                return response()->json($response, 200);
            }
        } catch (Exception $e) {
            $response = [
                'success' => false,
                'type' => 'error',
                'message' => $e->getMessage()
            ];
            return response()->json($response, 400);
        }
    }

    public function status(Request $request)
    {
        $request->validate([
            'id' => 'exists:exam_sub2_categories,id|numeric',
            'status' => 'boolean'
        ]);

        try {
            $cat = ExamSub2Category::find($request->id);
            $cat->status = $request->status;
            $cat->save();
            return response()->json([
                'status' => true,
                'type' => 'success',
                'message' => 'Status Updated.'
            ], 200);
        } catch (Exception $e) {
            return response()->json([
                'status' => false,
                'type' => 'error',
                'message' => $e->getMessage()
            ], 200);
        }
    }

    public function destroy(Request $request)
    {

        $destinationPath = public_path('/exam/sub2category/');
        $data = ExamSub2Category::where('id', $request->id)->first();
        // dd($data);
        // try {
        //     if (!empty($data)) {
        //         unlink($destinationPath . $data->image);
        //     }
        // } catch (Exception $e) {
        //     echo $e->getMessage();
        // }

        if ($data) {
            $data->delete();
            $response = [
                'type' => 'success',
                'success' => true,
                'message' => 'Sub 2 Category Removed',
            ];
            return response()->json($response, 200);
        }
        $response = [
            'success' => false,
            'type' => 'error',
            'message' => 'Something went wrong',
        ];
        return response()->json($response, 404);
    }
}
