<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Language;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class LanguageController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function lang_index()
    {
        $page_title = 'Language';
        $page_description = 'Some description for the page';
        $action = __FUNCTION__;
        $data = Language::orderBy('id', 'desc')->get();
        return view('admin.language.index', compact('page_title', 'page_description', 'action', 'data'));
    }

    public function lang_store(Request $request)
    {
        $request->validate(
            [
                'language_name' => 'bail|required|string',
            ],
            [
                'language_name.required' => 'Please Enter language name.',
            ]
        );

        try {
            if (Auth::user()->status == 1) {

                $lang = new Language();

                $lang->language_name = $request->language_name;
                $lang->save();


                $response = [
                    'success' => true,
                    'type' => 'success',
                    'message' => 'language Added'
                ];
                return response()->json($response, 200);
            } else {
                $response = [
                    'success' => false,
                    'type' => 'error',
                    'message' => 'You Are Not Eligible.'
                ];
                return response()->json($response, 200);
            }
        } catch (Exception $e) {
            $response = [
                'success' => false,
                'type' => 'error',
                'message' => $e->getMessage()
            ];
            return response()->json($response, 400);
        }
    }

    public function lang_update(Request $request)
    {
        $request->validate([
                'id' => 'exists:languages,id|numeric',
            ]);

        try {
            if (Auth::user()->status == 1) {

                $lang = Language::where('id',$request->id)->first();

                $lang->language_name = $request->language_name;
                $lang->save();

                $response = [
                    'success' => true,
                    'type' => 'success',
                    'message' => 'Language Updated'
                ];
                return response()->json($response, 200);
            } else {
                $response = [
                    'success' => false,
                    'type' => 'error',
                    'message' => 'You Are Not Eligible.'
                ];
                return response()->json($response, 200);
            }
        } catch (Exception $e) {
            $response = [
                'success' => false,
                'type' => 'error',
                'message' => $e->getMessage()
            ];
            return response()->json($response, 400);
        }
    }

    public function lang_status(Request $request)
    {
        $request->validate([
            'id' => 'exists:languages,id|numeric',
            'status' => 'boolean'
        ]);

        try {
            $lang = Language::find($request->id);
            $lang->status = $request->status;
            $lang->save();
            return response()->json([
                'status' => true,
                'type' => 'success',
                'message' => 'Status Updated.'
            ], 200);
        } catch (Exception $e) {
            return response()->json([
                'status' => false,
                'type' => 'error',
                'message' => $e->getMessage()
            ], 200);
        }
    }

    public function destroy(Request $request)
    {

        $data = Language::where('id', $request->id)->first();

        if ($data) {
            $data->delete();
            $response = [
                'type' => 'success',
                'success' => true,
                'message' => 'Language Removed',
            ];
            return response()->json($response, 200);
        }
        $response = [
            'success' => false,
            'type' => 'error',
            'message' => 'Something went wrong',
        ];
        return response()->json($response, 404);
    }
}
