<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Language;
use App\Models\QuestionAnswer;
use App\Models\QuestMainCategory;
use App\Models\QuestSubCategory;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class QuestionAnsController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function quest_index()
    {
        $page_title = 'See Question Answer';
        $page_description = 'Some description for the page';
        $action = __FUNCTION__;
        $data = QuestionAnswer::with(['languages', 'questcategory','questsubcategory'])->orderBy('id', 'desc')->get();

        return view('admin.questionAnswer.index', compact('page_title', 'page_description', 'action', 'data'));
    }

    public function quest_create()
    {
        $page_title = 'Add Question Answer';
        $page_description = 'Some description for the page';
        $action = __FUNCTION__;
        $languages = Language::where('status', 1)->get();
        $maincategory = QuestMainCategory::where('status', 1)->get();
        $subcategory = QuestSubCategory::where('status', 1)->get();
        return view('admin.questionAnswer.create', compact('page_title', 'page_description', 'action', 'languages', 'maincategory','subcategory'));
    }

    public function store(Request $request)
    {
        $request->validate(
            [
                'language_id' => 'bail|required|exists:languages,id|numeric',
                'category_id' => 'bail|required|exists:quest_main_categories,id|numeric',
                'subcategory_id' => 'bail|required|exists:quest_sub_categories,id|numeric',
                'title' =>  'bail|required|string',
                'description' =>  'bail|required|string',
                'image' => 'bail|nullable|image|mimes:jpg,png,jpeg,gif',
            ],
            [
                'language_id.required' => 'Please Select language.',
                'category_id.required' => 'Please Select Category.',
                'subcategory_id.required' => 'Please Select SubCategory.',
                'title.required' => 'Please Enter question.',
                'description.required' => 'Please Give Description.',
            ]
        );

        try {
            if (Auth::user()->status == 1) {

                $input = $request->input();
                unset($input['_token']);

                if ($request->hasfile('image')) {

                    $destinationPath = public_path('/QuestionAnswer/banner/');
                    $image = $request->image;
                    $fileName = 'CA-' . uniqid() . '.' . $image->extension();
                    $fileName = str_replace(" ", "-", $fileName);


                    if (!is_dir($destinationPath)) {
                        mkdir($destinationPath, 0777, TRUE);
                        @chmod($destinationPath, 0777);
                    }
                    $image->move($destinationPath, $fileName);
                    $input['image'] = $fileName;
                }

                QuestionAnswer::create($input);
                $response = [
                    'success' => true,
                    'type' => 'success',
                    'message' => 'New Question Added'
                ];
                return response()->json($response, 200);
            } else {
                $response = [
                    'success' => false,
                    'type' => 'error',
                    'message' => 'You Are Not Eligible.'
                ];
                return response()->json($response, 200);
            }
        } catch (Exception $e) {
            $response = [
                'success' => false,
                'type' => 'error',
                'message' => $e->getMessage()
            ];
            return response()->json($response, 400);
        }
    }

    public function quest_edit(Request $request)
    {
        $data = QuestionAnswer::find($request->id);
        $page_title = 'Edit Question Answer';
        $page_description = 'Some description for the page';
        $action = __FUNCTION__;
        $languages = Language::where('status', 1)->get();
        $maincategory = QuestMainCategory::where('status', 1)->get();
        $subcategory = QuestSubCategory::where('status', 1)->get();

        return view('admin.questionAnswer.update', compact('page_title', 'page_description', 'action', 'languages', 'maincategory', 'data','subcategory'));
    }
    public function update(Request $request)
    {
        $request->validate([
            'id' => 'bail|exists:question_answers,id|numeric',
        ]);

        try {
            if (Auth::user()->status == 1) {

                $input = $request->input();
                unset($input['_token']);
                // unset($input['_method']);
                if ($request->hasfile('image')) {

                    $destinationPath = public_path('/QuestionAnswer/banner/');
                    $data = QuestionAnswer::where('id', $request->id)->first();
                    // dd($data);
                    try {
                        if (!empty($data)) {
                            unlink($destinationPath . $data->image);
                        }
                    } catch (Exception $e) {
                        echo $e->getMessage();
                    }

                    $image = $request->image;
                    $fileName = 'QA-' . uniqid() . '.' . $image->extension();
                    $fileName = str_replace(" ", "-", $fileName);


                    if (!is_dir($destinationPath)) {
                        mkdir($destinationPath, 0777, TRUE);
                        @chmod($destinationPath, 0777);
                    }
                    $image->move($destinationPath, $fileName);
                    $input['image'] = $fileName;
                }


                $id = $request->id;
                QuestionAnswer::where("id", $id)->update($input);
                $response = [
                    'success' => true,
                    'type' => 'success',
                    'message' => 'Question Answer Updated'
                ];
                return response()->json($response, 200);
            } else {
                $response = [
                    'success' => false,
                    'type' => 'error',
                    'message' => 'You Are Not Eligible.'
                ];
                return response()->json($response, 200);
            }
        } catch (Exception $e) {
            $response = [
                'success' => false,
                'type' => 'error',
                'message' => $e->getMessage()
            ];
            return response()->json($response, 400);
        }
    }

    public function status(Request $request)
    {
        $request->validate([
            'id' => 'exists:question_answers,id|numeric',
            'status' => 'boolean'
        ]);

        try {
            $cat = QuestionAnswer::find($request->id);
            $cat->status = $request->status;
            $cat->save();
            return response()->json([
                'status' => true,
                'type' => 'success',
                'message' => 'Status Updated.'
            ], 200);
        } catch (Exception $e) {
            return response()->json([
                'status' => false,
                'type' => 'error',
                'message' => $e->getMessage()
            ], 200);
        }
    }

    public function destroy(Request $request)
    {

        // $destinationPath = public_path('/QuestionAnswer/banner/');
        $data = QuestionAnswer::where('id', $request->id)->first();
        // dd($data);
        // try {
        //     if (!empty($data)) {
        //         unlink($destinationPath . $data->image);
        //     }
        // } catch (Exception $e) {
        //     echo $e->getMessage();
        // }

        if ($data) {
            $data->delete();
            $response = [
                'type' => 'success',
                'success' => true,
                'message' => 'Question Answer Removed',
            ];
            return response()->json($response, 200);
        }
        $response = [
            'success' => false,
            'type' => 'error',
            'message' => 'Something went wrong',
        ];
        return response()->json($response, 404);
    }
}
