<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Language;
use App\Models\QuizMainCategory;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class QuizMainCategoryController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function quizmain_index()
    {
        $page_title = 'Main Category';
        $page_description = 'Some description for the page';
        $action = __FUNCTION__;
        $data = QuizMainCategory::with('languages')->orderBy('id', 'desc')->get();
        $languages = Language::where('status',1)->get();
        return view('admin.quiz.category', compact('page_title', 'page_description', 'action', 'data','languages'));
    }

    // public function data(Request $request)
    // {
    //     $limit = $request->input('limit') ?? 10;
    //     $offset = $request->input('offset') ?? 0;
    //     $sort = $request->input('sort') ?? 'id';
    //     $order = $request->input('order') ?? 'desc';

    //     // $dr = $request->input('dr');
    //     // $empid = $request->input('emp');
    //     // $pmtstatus = $request->input('pmt');

    //     $where = [];

    //     // if ($dr != '') {
    //     //     $ex = explode('-', $dr);
    //     //     $d1 = trim($ex[0]);
    //     //     $d1 = explode('%', $d1);
    //     //     $dd1 = explode('/', $d1[0]);
    //     //     $dd11 = $dd1[2] . '-' . $dd1[0] . '-' . $dd1[1];

    //     //     $d2 = trim($ex[1]);
    //     //     $dd1 = explode('%', $d2);
    //     //     $dd2 = explode('/', $dd1[0]);
    //     //     $dd22 = $dd2[2] . '-' . $dd2[0] . '-' . $dd2[1];

    //     //     $where[] = ["created_at", ">=", $dd11];
    //     //     $where[] = ["created_at", "<=", $dd22];
    //     // }

    //     // if ($empid != '') {
    //     //     $where[] = ["employee_id", $empid];
    //     // }

    //     // if ($pmtstatus !== null && $pmtstatus !== '') {
    //     //     $where[] = ["ispaid", "=", $pmtstatus];
    //     // }
    //     $search = $request->input("search");

    //     if ($search != "") {
    //         $where[] = ["category_name", "LIKE", "%$search%"];
    //     }

    //     $query = QuizMainCategory::with('languages')
    //         ->where($where)
    //         // ->where('status',1)
    //         ->orderBy($sort, $order);

    //     $total = $query->count();

    //     $data = $query->offset($offset)->limit($limit)->get();

    //     $bulkData = [
    //         'total' => $total,
    //         'rows' => [],
    //     ];

    //     $count = 1;
    //     foreach ($data as $row) {
    //         $tempRow = [
    //             'id' => $count,
    //             'language_name' => $row->languages->language_name,
    //             'category_name' => $row->category_name,
    //             'image' => $row->image,
    //         ];

    //         $bulkData['rows'][] = $tempRow;
    //         $count++;
    //     }

    //     return response()->json($bulkData, 200, [], JSON_UNESCAPED_UNICODE);
    // }

    public function store(Request $request)
    {
        $request->validate(
            [
                'language_id' => 'bail|required|exists:languages,id|numeric',
                'category_name' => 'bail|required|string',
                'image' => 'bail|nullable|image|mimes:jpg,png,jpeg,gif|max:2048',
            ],
            [
                'language_id.required' => 'Please Select language.',
                'category_name.required' => 'Please Enter Category Name.',
            ]
        );

        try {
            if (Auth::user()->status == 1) {

                // $cat = new QuizMainCategory();
                // $cat->language_id = $request->language_id;
                // $cat->category_name = $request->category_name;
                // $cat->save();

                $input = $request->input();
                unset($input['_token']);

                if ($request->hasfile('image')) {

                    $destinationPath = public_path('/quiz/maincategory/');

                    $image = $request->image;
                    $fileName = 'quizMain-' . uniqid() . '.' . $image->extension();
                    $fileName = str_replace(" ", "-", $fileName);


                    if (!is_dir($destinationPath)) {
                        mkdir($destinationPath, 0777, TRUE);
                        @chmod($destinationPath, 0777);
                    }
                    $image->move($destinationPath, $fileName);
                    $input['image'] = $fileName;
                }

                QuizMainCategory::create($input);


                $response = [
                    'success' => true,
                    'type' => 'success',
                    'message' => 'Category Added'
                ];
                return response()->json($response, 200);
            } else {
                $response = [
                    'success' => false,
                    'type' => 'error',
                    'message' => 'You Are Not Eligible.'
                ];
                return response()->json($response, 200);
            }
        } catch (Exception $e) {
            $response = [
                'success' => false,
                'type' => 'error',
                'message' => $e->getMessage()
            ];
            return response()->json($response, 400);
        }
    }


    public function update(Request $request)
    {
        $request->validate([
            'id' => 'exists:quiz_main_categories,id|numeric',
        ]);

        try {
            if (Auth::user()->status == 1) {

                $input = $request->input();
                unset($input['_token']);
                // unset($input['_method']);
                if ($request->hasfile('image')) {

                    $destinationPath = public_path('/quiz/maincategory/');
                    $data = QuizMainCategory::where('id', $request->id)->first();
                    // dd($data);
                    try {
                        if (!empty($data)) {
                            unlink($destinationPath . $data->image);
                        }
                    } catch (Exception $e) {
                        echo $e->getMessage();
                    }

                    $image = $request->image;
                    $fileName = 'quizMain-' . uniqid() . '.' . $image->extension();
                    $fileName = str_replace(" ", "-", $fileName);


                    if (!is_dir($destinationPath)) {
                        mkdir($destinationPath, 0777, TRUE);
                        @chmod($destinationPath, 0777);
                    }
                    $image->move($destinationPath, $fileName);
                    $input['image'] = $fileName;
                }
                $id = $request->id;
                QuizMainCategory::where("id", $id)->update($input);
                $response = [
                    'success' => true,
                    'type' => 'success',
                    'message' => 'Category Updated'
                ];
                return response()->json($response, 200);
            } else {
                $response = [
                    'success' => false,
                    'type' => 'error',
                    'message' => 'You Are Not Eligible.'
                ];
                return response()->json($response, 200);
            }
        } catch (Exception $e) {
            $response = [
                'success' => false,
                'type' => 'error',
                'message' => $e->getMessage()
            ];
            return response()->json($response, 400);
        }
    }

    public function status(Request $request)
    {
        $request->validate([
            'id' => 'exists:quiz_main_categories,id|numeric',
            'status' => 'boolean'
        ]);

        try {
            $cat = QuizMainCategory::find($request->id);
            $cat->status = $request->status;
            $cat->save();
            return response()->json([
                'status' => true,
                'type' => 'success',
                'message' => 'Status Updated.'
            ], 200);
        } catch (Exception $e) {
            return response()->json([
                'status' => false,
                'type' => 'error',
                'message' => $e->getMessage()
            ], 200);
        }
    }

    public function destroy(Request $request)
    {

        $destinationPath = public_path('/quiz/maincategory/');
        $data = QuizMainCategory::where('id', $request->id)->first();
        // dd($data);
        // try {
        //     if (!empty($data)) {
        //         unlink($destinationPath . $data->image);
        //     }
        // } catch (Exception $e) {
        //     echo $e->getMessage();
        // }

        if ($data) {
            $data->delete();
            $response = [
                'type' => 'success',
                'success' => true,
                'message' => 'Category Removed',
            ];
            return response()->json($response, 200);
        }
        $response = [
            'success' => false,
            'type' => 'error',
            'message' => 'Something went wrong',
        ];
        return response()->json($response, 404);
    }
}
