<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\QuizSub2Category;
use App\Models\Language;
use App\Models\QuizMainCategory;
use App\Models\QuizSubCategory;
use App\Models\QuizQuestion;
use Exception;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;

class QuizQuestionController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function quiz_index()
    {
        $page_title = 'See All Question';
        $page_description = 'Some description for the page';
        $action = __FUNCTION__;
        $data = QuizQuestion::with(['languages','quizcategory','quizsubcategory','quizsub2category'])->orderBy('id', 'desc')->get();
        $languages = Language::where('status',1)->get();
        $maincategory = QuizMainCategory::where('status',1)->get();
        $subcategory = QuizSubCategory::where('status',1)->get();
        $sub2category = QuizSub2Category::where('status',1)->get();
        return view('admin.quiz.index', compact('page_title', 'page_description', 'action', 'data','languages','maincategory','subcategory','sub2category'));
    }

    public function quiz_create()
    {
        $page_title = 'Add Question';
        $page_description = 'Some description for the page';
        $action = __FUNCTION__;
        $languages = Language::where('status',1)->get();
        $maincategory = QuizMainCategory::where('status',1)->get();
        $subcategory = QuizSubCategory::where('status',1)->get();
        $sub2category = QuizSub2Category::where('status',1)->get();
        return view('admin.quiz.create', compact('page_title', 'page_description', 'action','languages','maincategory','subcategory','sub2category'));
    }

    public function store(Request $request)
    {
        $request->validate(
            [
                'language_id' => 'bail|required|exists:languages,id|numeric',
                'category_id' => 'bail|required|exists:quiz_main_categories,id|numeric',
                'subcategory_id' => 'bail|required|exists:quiz_sub_categories,id|numeric',
                'sub2category_id' => 'bail|required|exists:quiz_sub2_categories,id|numeric',
                'question' =>  'bail|required|string',
                'one' =>  'bail|required|string',
                'two' =>  'bail|required|string',
                'three' =>  'bail|required|string',
                'four' =>  'bail|required|string',
                'answer' =>  'bail|required|string',
                'image' => 'bail|nullable|image|mimes:jpg,png,jpeg,gif|max:2048',
            ],
            [
                'language_id.required' => 'Please Select language.',
                'category_id.required' => 'Please Select Category.',
                'subcategory_id.required' => 'Please Select Sub Category.',
                'sub2category_id.required' => 'Please Select Sub 2 Category.',
                'question.required' => 'Please Enter Question.',
                'one.required' => 'Please Enter Option 1st.',
                'two.required' => 'Please Enter Option 2nd.',
                'three.required' => 'Please Enter Option 3rd.',
                'four.required' => 'Please Enter Option 4th.',
                'answer.required' => 'Please select Answer.',
            ]
        );

        try {
            if (Auth::user()->status == 1) {

                $input = $request->input();
                unset($input['_token']);

                if ($request->hasfile('image')) {

                    $destinationPath = public_path('/quiz/question/');

                    $image = $request->image;
                    $fileName = 'quizQuestion-' . uniqid() . '.' . $image->extension();
                    $fileName = str_replace(" ", "-", $fileName);


                    if (!is_dir($destinationPath)) {
                        mkdir($destinationPath, 0777, TRUE);
                        @chmod($destinationPath, 0777);
                    }
                    $image->move($destinationPath, $fileName);
                    $input['image'] = $fileName;
                }

                QuizQuestion::create($input);


                $response = [
                    'success' => true,
                    'type' => 'success',
                    'message' => 'New Question Added'
                ];
                return response()->json($response, 200);
            } else {
                $response = [
                    'success' => false,
                    'type' => 'error',
                    'message' => 'You Are Not Eligible.'
                ];
                return response()->json($response, 200);
            }
        } catch (Exception $e) {
            $response = [
                'success' => false,
                'type' => 'error',
                'message' => $e->getMessage()
            ];
            return response()->json($response, 400);
        }
    }


    public function quiz_edit(Request $request)
    {
        $data = QuizQuestion::find($request->id);
        $page_title = 'Edit Question';
        $page_description = 'Some description for the page';
        $action = __FUNCTION__;
        $languages = Language::where('status',1)->get();
        $maincategory = QuizMainCategory::where('status',1)->get();
        $subcategory = QuizSubCategory::where('status',1)->get();
        $sub2category = QuizSub2Category::where('status',1)->get();
        return view('admin.quiz.update', compact('page_title', 'page_description', 'action','languages','maincategory','subcategory','sub2category','data'));
    }
    public function update(Request $request)
    {
        $request->validate([
            'id' => 'bail|exists:quiz_questions,id|numeric',
        ]);

        try {
            if (Auth::user()->status == 1) {

                $input = $request->input();
                unset($input['_token']);
                // unset($input['_method']);
                if ($request->hasfile('image')) {

                    $destinationPath = public_path('/quiz/question/');
                    $data = QuizQuestion::where('id', $request->id)->first();
                    // dd($data);
                    try {
                        if (!empty($data)) {
                            unlink($destinationPath . $data->image);
                        }
                    } catch (Exception $e) {
                        echo $e->getMessage();
                    }

                    $image = $request->image;
                    $fileName = 'quizQuestion-' . uniqid() . '.' . $image->extension();
                    $fileName = str_replace(" ", "-", $fileName);


                    if (!is_dir($destinationPath)) {
                        mkdir($destinationPath, 0777, TRUE);
                        @chmod($destinationPath, 0777);
                    }
                    $image->move($destinationPath, $fileName);
                    $input['image'] = $fileName;
                }
                $id = $request->id;
                QuizQuestion::where("id", $id)->update($input);
                $response = [
                    'success' => true,
                    'type' => 'success',
                    'message' => 'Question Updated'
                ];
                return response()->json($response, 200);
            } else {
                $response = [
                    'success' => false,
                    'type' => 'error',
                    'message' => 'You Are Not Eligible.'
                ];
                return response()->json($response, 200);
            }
        } catch (Exception $e) {
            $response = [
                'success' => false,
                'type' => 'error',
                'message' => $e->getMessage()
            ];
            return response()->json($response, 400);
        }
    }

    public function status(Request $request)
    {
        $request->validate([
            'id' => 'exists:quiz_questions,id|numeric',
            'status' => 'boolean'
        ]);

        try {
            $cat = QuizQuestion::find($request->id);
            $cat->status = $request->status;
            $cat->save();
            return response()->json([
                'status' => true,
                'type' => 'success',
                'message' => 'Status Updated.'
            ], 200);
        } catch (Exception $e) {
            return response()->json([
                'status' => false,
                'type' => 'error',
                'message' => $e->getMessage()
            ], 200);
        }
    }

    public function destroy(Request $request)
    {

        $destinationPath = public_path('/quiz/question/');
        $data = QuizQuestion::where('id', $request->id)->first();
        // dd($data);
        // try {
        //     if (!empty($data)) {
        //         unlink($destinationPath . $data->image);
        //     }
        // } catch (Exception $e) {
        //     echo $e->getMessage();
        // }

        if ($data) {
            $data->delete();
            $response = [
                'type' => 'success',
                'success' => true,
                'message' => 'Question Removed',
            ];
            return response()->json($response, 200);
        }
        $response = [
            'success' => false,
            'type' => 'error',
            'message' => 'Something went wrong',
        ];
        return response()->json($response, 404);
    }
}
