<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CurrentAffair extends Model
{
    use HasFactory;
    protected $fillable = [
        'language_id',
        'category_id',
        'subcategory_id',
        'title',
        'description',
        'image',
        'status'
    ];

    public function languages()
    {
        return $this->hasOne(Language::class,'id','language_id');
    }
    public function currentcategory()
    {
        return $this->hasOne(CurrentMainCategory::class,'id','category_id');
    }
    public function currentsubcategory()
    {
        return $this->hasOne(CurrentSubCategory::class,'id','subcategory_id');
    }

}
