<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DailyNews extends Model
{
    use HasFactory;
    protected $fillable = [
        'language_id',
        'category_id',
        'title',
        'description',
        'image',
        'status'
    ];

    public function languages()
    {
        return $this->hasOne(Language::class,'id','language_id');
    }
    public function dailymaincategory()
    {
        return $this->hasOne(DailyMainCategory::class,'id','category_id');
    }

}
