<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Ebook extends Model
{
    use HasFactory;
    protected $fillable = [
        'language_id',
        'category_id',
        'subcategory_id',
        'sub2category_id',
        'title',
        'ebookpdf',
        'image',
        'status'
    ];

    public function languages()
    {
        return $this->hasOne(Language::class,'id','language_id');
    }
    public function ebookcategory()
    {
        return $this->hasOne(EbookMainCategory::class,'id','category_id');
    }
    public function ebooksubcategory()
    {
        return $this->hasOne(EbookSubCategory::class,'id','subcategory_id');
    }
    public function ebooksub2category()
    {
        return $this->hasOne(EbookSub2Category::class,'id','sub2category_id');
    }
}
