<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class EbookSub2Category extends Model
{
    use HasFactory;
    protected $fillable = [
        'language_id',
        'category_id',
        'subcategory_id',
        'sub2category_name',
        'image',
        'status'
    ];

    public function languages()
    {
        return $this->hasOne(Language::class,'id','language_id');
    }
    public function ebookcategory()
    {
        return $this->hasOne(EbookMainCategory::class,'id','category_id');
    }
    public function ebooksubcategory()
    {
        return $this->hasOne(EbookSubCategory::class,'id','subcategory_id');
    }
}
