<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Exam extends Model
{
    use HasFactory;
    protected $fillable = [
        'language_id',
        'category_id',
        'subcategory_id',
        'sub2category_id',
        'question',
        'one',
        'two',
        'three',
        'four',
        'answer',
        'image',
        'status'
    ];

    public function languages()
    {
        return $this->hasOne(Language::class,'id','language_id');
    }
    public function examcategory()
    {
        return $this->hasOne(ExamMainCategory::class,'id','category_id');
    }
    public function examsubcategory()
    {
        return $this->hasOne(ExamSubCategory::class,'id','subcategory_id');
    }
    public function examsub2category()
    {
        return $this->hasOne(ExamSub2Category::class,'id','sub2category_id');
    }
}
