<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ExamSub2Category extends Model
{
    use HasFactory;
    protected $fillable = [
        'language_id',
        'category_id',
        'subcategory_id',
        'sub2category_name',
        'image',
        'status'
    ];

    public function languages()
    {
        return $this->hasOne(Language::class,'id','language_id');
    }
    public function examcategory()
    {
        return $this->hasOne(ExamMainCategory::class,'id','category_id');
    }
    public function examsubcategory()
    {
        return $this->hasOne(ExamSubCategory::class,'id','subcategory_id');
    }
}
