<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class QuestionAnswer extends Model
{
    use HasFactory;
    protected $fillable = [
        'language_id',
        'category_id',
        'subcategory_id',
        'title',
        'description',
        'image',
        'status'
    ];

    public function languages()
    {
        return $this->hasOne(Language::class,'id','language_id');
    }
    public function questcategory()
    {
        return $this->hasOne(QuestMainCategory::class,'id','category_id');
    }
    public function questsubcategory()
    {
        return $this->hasOne(QuestSubCategory::class,'id','subcategory_id');
    }
}
