<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class QuizQuestion extends Model
{
    use HasFactory;
    protected $fillable = [
        'language_id',
        'category_id',
        'subcategory_id',
        'sub2category_id',
        'question',
        'one',
        'two',
        'three',
        'four',
        'answer',
        'image',
        'status'
    ];

    public function languages()
    {
        return $this->hasOne(Language::class,'id','language_id');
    }
    public function quizcategory()
    {
        return $this->hasOne(QuizMainCategory::class,'id','category_id');
    }
    public function quizsubcategory()
    {
        return $this->hasOne(QuizSubCategory::class,'id','subcategory_id');
    }
    public function quizsub2category()
    {
        return $this->hasOne(QuizSub2Category::class,'id','sub2category_id');
    }
}
