<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class QuizSub2Category extends Model
{
    use HasFactory;
    protected $fillable = [
        'language_id',
        'category_id',
        'subcategory_id',
        'sub2category_name',
        'image',
        'status'
    ];

    public function languages()
    {
        return $this->hasOne(Language::class,'id','language_id');
    }
    public function quizcategory()
    {
        return $this->hasOne(QuizMainCategory::class,'id','category_id');
    }
    public function quizsubcategory()
    {
        return $this->hasOne(QuizSubCategory::class,'id','subcategory_id');
    }
}
