<?php

namespace App\Providers;

use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Gate;

class AuthServiceProvider extends ServiceProvider
{
    /**
     * The policy mappings for the application.
     *
     * @var array
     */
    protected $policies = [
        // 'App\Models\Model' => 'App\Policies\ModelPolicy',
    ];

    /**
     * Register any authentication / authorization services.
     *
     * @return void
     */
    public function boot()
    {
        $this->registerPolicies();

        Gate::define('onlyadmin', function ($user) {
            if ($user->email === 'admin@gmail.com' && $user->usertype === 'admin' && $user->status == 1)
                return true;
            else
                return false;
        });

        Gate::define('for_employee', function ($user) {
            if ( $user->status === 1 && $user->usertype === 'employee')
                return true;
            else
                return false;
        });
    }
}
