<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateQuizQuestionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('quiz_questions', function (Blueprint $table) {
            $table->id()->autoIncrement();
            $table->string('language_id');
            $table->string('category_id');
            $table->string('subcategory_id')->nullable();
            $table->string('sub2category_id')->nullable();
            $table->text('question');
            $table->string('one');
            $table->string('two');
            $table->string('three');
            $table->string('four');
            $table->enum('answer',['one','two','three','four']);
            $table->string('image')->nullable();
            $table->boolean('status')->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('quiz_questions');
    }
}
