@extends('layout.default')



{{-- Content --}}
@section('content')
    <div class="container-fluid">

        <!-- row -->
        <div class="row">

            <div class="col-xl-12 col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">{{ $page_title }}</h4>
                    </div>
                    <div class="card-body">
                        <div class="basic-form">
                            <form id="addform">
                                @csrf
                                <div class="form-row">

                                    {{-- <div class="col-md-3 mb-2">
                                        <input type="text" name="title" id="title" class="form-control"
                                            placeholder="Enter title (optional)">
                                    </div> --}}
                                    <div class="col-md-3 mb-2">
                                        <input type="text" name="link" id="link" class="form-control"
                                            placeholder="Enter link">
                                    </div>

                                    <div class="col-md-3 mb-3">
                                        <div class="input-group">
                                            <div class="input-group">
                                                <div class="">
                                                    <input type="file" name="image" class="form-control"
                                                        accept="image/*">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-3 mb-2">
                                        <button type="submit" class="btn btn-primary btn-block">Submit</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>


            <div class="col-md-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Banner List</h4>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table id="example" class="display min-w850">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        {{-- <th>Title</th> --}}
                                        <th>Link</th>
                                        <th>Image</th>
                                        <th>Status</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($data as $key => $cat)
                                        <tr id="CatRow-{{ $cat->id }}">
                                            <td>{{ $key + 1 }}</td>
                                            {{-- <td>{{ $cat->title ?? '' }}</td> --}}
                                            <td>{{ $cat->link ?? '' }}</td>
                                            @if (isset($cat['image']))
                                                <td>
                                                    <img src="{{ asset('/banners/image/' . $cat['image']) }}"
                                                        width='80%' height='80px' alt="">
                                                </td>
                                            @else
                                                <td></td>
                                            @endif
                                            <td>
                                                <div class="custom-control custom-checkbox mb-3 checkbox-warning check-xl">
                                                    <input type="checkbox" class="custom-control-input btn-status"
                                                        id="check-{{ $cat->id }}" data-catid="{{ $cat->id }}"
                                                        {{ $cat->status ? 'checked' : '' }}>
                                                    <label class="custom-control-label"
                                                        for="check-{{ $cat->id }}"></label>
                                                </div>
                                            </td>
                                            <td>
                                                <div class="d-flex">
                                                    {{-- <a  data-cat-id="{{ $cat->id }}"
                                                        data-lang-id="{{ $cat->language_id }}"
                                                        data-cat-name="{{ $cat->category_name }}"
                                                        class="btn btn-primary shadow btn-xs sharp mr-1 btn-edit text-white"><i
                                                            class="fa fa-pencil"></i></a> --}}
                                                    <a  class="btn btn-danger shadow btn-xs sharp text-white btn-delete"
                                                        data-cat-id="{{ $cat->id }}"><i class="fa fa-trash"></i></a>
                                                </div>
                                            </td>

                                        </tr>
                                    @endforeach
                                </tbody>

                            </table>


                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>



@endsection

@section('scripts')

    <script>
        $('.btn-status').on('click', function() {
            var catId = $(this).data('catid');
            var status = $(this).is(':checked') ? 1 : 0;
            // console.log(status);
            $.ajax({
                type: "post",
                url: "{{ route('banners.status') }}",
                data: {
                    _token: "{{ csrf_token() }}",
                    id: catId,
                    status: status
                },
                success: function(response) {

                    $('#language_name').val('');
                    // console.log(response);
                    toastr.success("", response.message, {
                        timeOut: 4000,
                        closeButton: !0,
                        newestOnTop: !0,
                        progressBar: !0,
                        positionClass: "toast-top-right",

                    });
                },
                error: function(xhr, status, error) {
                    var errors = xhr.responseJSON.errors;
                    var errorMessage = '';

                    // Construct error message
                    $.each(errors, function(key, value) {
                        errorMessage += value + '<br>';
                    });

                    toastr.error("", errorMessage, {
                        timeOut: 5000,
                        closeButton: !0,
                        debug: !1,
                        newestOnTop: !0,
                        progressBar: !0,
                        positionClass: "toast-top-right",

                    });

                    // console.log(response);
                }
            });

        });
    </script>
    <script>
        $('#addform').submit(function(event) {
            event.preventDefault();
            var formData = new FormData(this);
            // console.log(formData)
            $.ajax({
                type: "POST",
                url: "{{ route('banners.store') }}",
                data: formData,
                cache: false,
                contentType: false,
                processData: false,
                success: function(response) {

                    $('#addform')[0].reset();
                    // console.log(response);
                    toastr.success("", response.message, {
                        timeOut: 4000,
                        closeButton: !0,
                        newestOnTop: !0,
                        progressBar: !0,
                        positionClass: "toast-top-right",
                    });
                    window.location.reload();
                },
                error: function(xhr, status, error) {
                    var errors = xhr.responseJSON.errors;
                    var errorMessage = '';

                    // Construct error message
                    $.each(errors, function(key, value) {
                        errorMessage += value + '<br>';
                    });

                    toastr.error("", errorMessage, {
                        timeOut: 5000,
                        closeButton: !0,
                        debug: !1,
                        newestOnTop: !0,
                        progressBar: !0,
                        positionClass: "toast-top-right",

                    });

                    // console.log(response);
                }
            });

        });
    </script>


    <script>
        $('.btn-delete').on('click', function() {
            var langid = $(this).data('cat-id');
            // console.log(langid);
            if (confirm('Are you sure? you want to delete this banner.')) {
                $.ajax({
                    type: "post",
                    url: "{{ route('banners.delete') }}",
                    data: {
                        _token: "{{ csrf_token() }}",
                        _method: "DELETE",
                        id: langid
                    },
                    success: function(response) {
                        $("#CatRow-" + langid).remove();
                        console.log(response);
                        toastr.success("", response.message, {
                            timeOut: 4000,
                            closeButton: !0,
                            newestOnTop: !0,
                            progressBar: !0,
                            positionClass: "toast-top-right",

                        });
                    },
                    error: function(xhr, status, error) {
                        var errors = xhr.responseJSON.errors;
                        var errorMessage = '';

                        // Construct error message
                        $.each(errors, function(key, value) {
                            errorMessage += value + '<br>';
                        });

                        toastr.error("", errorMessage, {
                            timeOut: 5000,
                            closeButton: !0,
                            debug: !1,
                            newestOnTop: !0,
                            progressBar: !0,
                            positionClass: "toast-top-right",

                        });

                        // console.log(response);
                    }
                });
            }
        });
    </script>
@endsection
