@extends('layout.default')

@section('content')
<div class="container-fluid">
    <div class="row ">
        <div class="col-xl-6 col-lg-6 m-auto">
            <div class="card mt-4">
                <div class="card-header">
                    <h1 class="m-auto">{{ $page_title }}</h1>
                </div>
                <div class="card-body">
                    @if (session('success'))
                        <div class="alert alert-success" role="alert">
                            {{ session('success') }}
                        </div>
                    @elseif(session('fails'))
                        <div class="alert alert-danger" role="alert">
                            {{ session('fails') }}
                        </div>
                    @endif
                    <div class="basic-form">
                        <form action="{{ route('admin.password') }}" method="POST">
                            @csrf
                            <div class="form-row">
                                <input type="hidden" value="{{ $data->id }}" name="userid">
                                <div class=" col-md-10 my-2 m-auto">
                                    {{-- <label for="current_pass">Current Password*</label> --}}
                                    <input type="password" name="current_pass"
                                        class="form-control @error('current_pass') is-invalid @enderror" required
                                        id="current_pass" placeholder="Current Password">

                                    @error('current_pass')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <br>
                                <div class=" col-md-10 my-2 m-auto">
                                    {{-- <label for="password">New Password*</label> --}}
                                    <input type="password" name="password"
                                        class="form-control @error('password') is-invalid @enderror" required id="password"
                                        placeholder="New Password">

                                    @error('password')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <br>
                                <div class=" col-md-10 my-2 m-auto">
                                    {{-- <label for="password_confirmation">Confirm Password*</label> --}}
                                    <input type="password" name="password_confirmation"
                                        class="form-control @error('password_confirmation') is-invalid @enderror" required
                                        id="password_confirmation" placeholder="Confirm Password">

                                    @error('password_confirmation')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <br>
                                <button type="submit" class="btn btn-primary light col-md-4 m-auto">Change
                                    Password</button>
                            </div>

                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
