@extends('layout.default')

{{-- Content --}}
@section('content')
    <div class="container-fluid">

        <!-- row -->
        <div class="row">

            <div class="col-xl-12 col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">{{ $page_title }}</h4>
                    </div>
                    <div class="card-body">
                        <div class="basic-form">
                            <form id="addform">
                                @csrf
                                <div class="form-row">

                                    <div class="form-group col-md-6 mb-2">
                                        <label for="language_id">Language*</label>
                                        <select name="language_id" id="language_id" required class="form-control">
                                            <option value="">Select Language</option>
                                            @foreach ($languages as $lang)
                                                <option value="{{ $lang->id }}">{{ $lang->language_name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="form-group col-md-6 mb-2">
                                        <label for="category_id">Category*</label>
                                        <select name="category_id" id="category_id" required class="form-control">
                                            <option value="">Select Category</option>
                                            @foreach ($maincategory as $cat)
                                                <option value="{{ $cat->id }}">{{ $cat->category_name }}</option>
                                            @endforeach
                                        </select>
                                    </div>

                                    <div class="form-group col-md-6 mb-2">
                                        <label for="subcategory_id">Sub Category*</label>
                                        <select name="subcategory_id" id="subcategory_id" required class="form-control">
                                            <option value="">Select SubCategory</option>
                                            @foreach ($subcategory as $subcat)
                                                <option value="{{ $subcat->id }}">{{ $subcat->subcategory_name }}</option>
                                            @endforeach
                                        </select>
                                    </div>


                                    <div class="form-group col-md-6 mb-2">
                                        <label for="title">Title*</label>
                                        <input type="text" name="title" id="title" required class="form-control"
                                            placeholder="Enter title">
                                    </div>


                                    {{-- <div class="form-group col-md-3 mb-3">
                                        <label class="">Image (optional)</label>
                                        <div class="input-group">
                                            <div class="">
                                                <input type="file" name="image" class="form-control"
                                                    accept="image/*">
                                            </div>
                                        </div>
                                    </div> --}}

                                    <div class="form-group col-md-12 mb-2">
                                        <label for="title">Description*</label>
                                        <textarea name="description" class="summernote" required id="description" cols="30" rows="10"></textarea>
                                    </div>

                                </div>
                                <div class="form-group row mt-4">
                                    <div class="col-sm-10 m-auto">
                                        <button type="submit" class="btn btn-primary btn-block">Submit</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
    <script>
        $('#addform').submit(function(event) {
            event.preventDefault();
            var formData = new FormData(this);
            // console.log(formData)
            $.ajax({
                type: "POST",
                url: "{{ route('current.store') }}",
                data: formData,
                cache: false,
                contentType: false,
                processData: false,
                success: function(response) {

                    $('#addform').find('input[type="text"]').val('');
                    // Reset select elements
                    $('#addform').find('select').prop('selectedIndex', 0);
                    // console.log(response);
                    toastr.success("", response.message, {
                        timeOut: 4000,
                        closeButton: !0,
                        newestOnTop: !0,
                        progressBar: !0,
                        positionClass: "toast-top-right",
                    });
                    window.location.reload();
                },
                error: function(xhr, status, error) {
                    var errors = xhr.responseJSON.errors;
                    var errorMessage = '';

                    // Construct error message
                    $.each(errors, function(key, value) {
                        errorMessage += value + '<br>';
                    });

                    toastr.error("", errorMessage, {
                        timeOut: 5000,
                        closeButton: !0,
                        debug: !1,
                        newestOnTop: !0,
                        progressBar: !0,
                        positionClass: "toast-top-right",

                    });

                    // console.log(response);
                }
            });

        });
    </script>
@endsection
