@extends('layout.default')



{{-- Content --}}
@section('content')
    <div class="container-fluid">

        <!-- row -->
        <div class="row">

            <div class="col-xl-12 col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">{{ $page_title }}</h4>
                    </div>
                    <div class="card-body">
                        <div class="basic-form">
                            <form id="addform">
                                @csrf
                                <div class="form-row">
                                    <div class="col-md-3 mb-2">
                                        <select name="language_id" id="" class="form-control">
                                            <option value="">Select Language</option>
                                            @foreach ($languages as $lang)
                                                <option value="{{ $lang->id }}">{{ $lang->language_name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="col-md-3 mb-2">
                                        <select name="category_id" id="" class="form-control">
                                            <option value="">Select Category</option>
                                            @foreach ($maincategory as $cat)
                                                <option value="{{ $cat->id }}">{{ $cat->category_name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="col-md-3 mb-2">
                                        <select name="subcategory_id" id="" class="form-control">
                                            <option value="">Select SubCategory</option>
                                            @foreach ($subcategory as $subcat)
                                                <option value="{{ $subcat->id }}">{{ $subcat->subcategory_name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="col-md-3 mb-2">
                                        <input type="text" name="sub2category_name" id="sub2category_name"
                                            class="form-control" placeholder="Enter Sub 2 category name">
                                    </div>

                                    {{-- <div class="col-md-3 mb-3">
                                        <div class="input-group">
                                            <div class="custom-file">
                                                <input type="file" name="image" class="form-control-file"
                                                    accept="image/*">
                                                <label class="custom-file-label"></label>
                                            </div>
                                        </div>
                                    </div> --}}
                                    <div class="col-md-3 mb-2">
                                        <button type="submit" class="btn btn-primary btn-block">Submit</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>


            <div class="col-md-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Sub Category List</h4>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table id="example" class="display min-w850">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Language Name</th>
                                        <th>Category Name</th>
                                        <th>SubCategory Name</th>
                                        <th>Sub2Category Name</th>
                                        {{-- <th>Image</th> --}}
                                        <th>Status</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($data as $key => $subcat2)
                                        <tr id="CatRow-{{ $subcat2->id }}">
                                            <td>{{ $key + 1 }}</td>
                                            <td>{{ $subcat2->languages->language_name ?? '' }}</td>
                                            <td>{{ $subcat2->ebookcategory->category_name ?? '' }}</td>
                                            <td>{{ $subcat2->ebooksubcategory->subcategory_name ?? '' }}</td>
                                            <td>{{ $subcat2->sub2category_name ?? '' }}</td>
                                            {{-- @if (isset($subcat2['image']))
                                                <td>
                                                    <img src="{{ asset('/ebook/sub2category/' . $subcat2['image']) }}"
                                                        width='80%' height='80px' alt="">
                                                </td>
                                            @else
                                                <td></td>
                                            @endif --}}
                                            <td>
                                                <div class="custom-control custom-checkbox mb-3 checkbox-warning check-xl">
                                                    <input type="checkbox" class="custom-control-input btn-status"
                                                        id="check-{{ $subcat2->id }}" data-catid="{{ $subcat2->id }}"
                                                        {{ $subcat2->status ? 'checked' : '' }}>
                                                    <label class="custom-control-label"
                                                        for="check-{{ $subcat2->id }}"></label>
                                                </div>
                                            </td>
                                            <td>
                                                <div class="d-flex">
                                                    <a data-subcat2-id="{{ $subcat2->id }}"
                                                        data-lang-id="{{ $subcat2->language_id }}"
                                                        data-cat-id="{{ $subcat2->category_id }}"
                                                        data-subcat-id="{{ $subcat2->subcategory_id }}"
                                                        data-subcat2-name="{{ $subcat2->sub2category_name }}"
                                                        class="btn btn-primary shadow btn-xs sharp mr-1 btn-edit text-white"><i
                                                            class="fa fa-pencil"></i></a>
                                                    <a class="btn btn-danger shadow btn-xs sharp btn-delete text-white"
                                                        data-subcat2-id="{{ $subcat2->id }}"><i
                                                            class="fa fa-trash"></i></a>
                                                </div>
                                            </td>

                                        </tr>
                                    @endforeach
                                </tbody>

                            </table>


                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>


    {{-- MOdal --}}
    <div class="modal fade" id="editmodal">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Edit Sub Category</h5>
                    <button type="button" class="close" data-dismiss="modal"><span>&times;</span>
                    </button>
                </div>
                <form id="updateform">
                    @csrf
                    <div class="modal-body">
                        <input type="hidden" name="id" value="" id="subcatid">
                        <div class="form-group">
                            <select name="language_id" id="lang_id" class="form-control">
                                <option value="">Select Language</option>
                                @foreach ($languages as $lang)
                                    <option value="{{ $lang->id }}">{{ $lang->language_name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <br>
                        <div class="form-group">
                            <select name="category_id" id="cat_id" class="form-control">
                                <option value="">Select Category</option>
                                @foreach ($maincategory as $cat)
                                    <option value="{{ $cat->id }}">{{ $cat->category_name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <br>
                        <div class="form-group">
                            <select name="subcategory_id" id="subcat_id" class="form-control">
                                <option value="">Select Sub Category</option>
                                @foreach ($subcategory as $subcat)
                                    <option value="{{ $subcat->id }}">{{ $subcat->subcategory_name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <br>
                        <input type="text" name="sub2category_name" value="" maxlength="30" class="form-control"
                            id="subcat2_name" placeholder="Sub2Category Name"
                            oninput="this.value = this.value.replace(/[^a-zA-Z .]/g, ''); this.value = this.value.replace(/(\..*)\./g, '$1');">
                    </div>
                    <div class="modal-footer">
                        {{-- <button type="button" class="btn btn-danger light" data-dismiss="modal">Close</button> --}}
                        <button type="submit" class="btn btn-primary">Save changes</button>
                    </div>

                </form>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
    <script>
        $(document).ready(function() {

            $('.btn-edit').on('click', function() {

                $('#editmodal').modal('show');
                let subcat2Id = $(this).data('subcat2-id');
                let subcat2Name = $(this).data('subcat2-name');
                let langid = $(this).data('lang-id');
                let catid = $(this).data('cat-id');
                let subcatid = $(this).data('subcat-id');
                $("#subcatid").val(subcat2Id); // Corrected variable name
                $("#subcat2_name").val(subcat2Name);
                $('#editmodal select[id="lang_id"]').find('option[value="' + langid + '"]').prop('selected',
                    true);
                $('#editmodal select[id="cat_id"]').find('option[value="' + catid + '"]').prop('selected',
                    true);
                $('#editmodal select[id="subcat_id"]').find('option[value="' + subcatid + '"]').prop(
                    'selected', true); // Corrected variable name
            });
        });
    </script>

    <script>
        $('.btn-status').on('click', function() {
            var catId = $(this).data('catid');
            var status = $(this).is(':checked') ? 1 : 0;
            // console.log(status);
            $.ajax({
                type: "post",
                url: "{{ route('ebooksub2.status') }}",
                data: {
                    _token: "{{ csrf_token() }}",
                    id: catId,
                    status: status
                },
                success: function(response) {

                    // console.log(response);
                    toastr.success("", response.message, {
                        timeOut: 4000,
                        closeButton: !0,
                        newestOnTop: !0,
                        progressBar: !0,
                        positionClass: "toast-top-right",
                    });
                },
                error: function(xhr, status, error) {
                    var errors = xhr.responseJSON.errors;
                    var errorMessage = '';

                    // Construct error message
                    $.each(errors, function(key, value) {
                        errorMessage += value + '<br>';
                    });

                    toastr.error("", errorMessage, {
                        timeOut: 5000,
                        closeButton: !0,
                        debug: !1,
                        newestOnTop: !0,
                        progressBar: !0,
                        positionClass: "toast-top-right",

                    });

                    // console.log(response);
                }
            });

        });
    </script>
    <script>
        $('#addform').submit(function(event) {
            event.preventDefault();
            var formData = new FormData(this);
            // console.log(formData)
            $.ajax({
                type: "POST",
                url: "{{ route('ebooksub2.store') }}",
                data: formData,
                cache: false,
                contentType: false,
                processData: false,
                success: function(response) {

                    $('#addform').find('input[type="text"]').val('');
                    // Reset select elements
                    $('#addform').find('select').prop('selectedIndex', 0);
                    // console.log(response);
                    toastr.success("", response.message, {
                        timeOut: 4000,
                        closeButton: !0,
                        newestOnTop: !0,
                        progressBar: !0,
                        positionClass: "toast-top-right",
                    });
                    window.location.reload();
                },
                error: function(xhr, status, error) {
                    var errors = xhr.responseJSON.errors;
                    var errorMessage = '';

                    // Construct error message
                    $.each(errors, function(key, value) {
                        errorMessage += value + '<br>';
                    });

                    toastr.error("", errorMessage, {
                        timeOut: 5000,
                        closeButton: !0,
                        debug: !1,
                        newestOnTop: !0,
                        progressBar: !0,
                        positionClass: "toast-top-right",

                    });

                    // console.log(response);
                }
            });

        });
    </script>

    <script>
        $('#updateform').submit(function(event) {
            event.preventDefault();
            var formData = new FormData(this);
            // console.log(formData)
            $.ajax({
                type: "POST",
                url: "{{ route('ebooksub2.update') }}",
                data: formData,
                cache: false,
                contentType: false,
                processData: false,
                success: function(response) {
                    // console.log(response);
                    toastr.success("", response.message, {
                        timeOut: 4000,
                        closeButton: !0,
                        newestOnTop: !0,
                        progressBar: !0,
                        positionClass: "toast-top-right",

                    });
                },
                error: function(xhr, status, error) {
                    var errors = xhr.responseJSON.errors;
                    var errorMessage = '';

                    // Construct error message
                    $.each(errors, function(key, value) {
                        errorMessage += value + '<br>';
                    });

                    toastr.error("", errorMessage, {
                        timeOut: 5000,
                        closeButton: !0,
                        debug: !1,
                        newestOnTop: !0,
                        progressBar: !0,
                        positionClass: "toast-top-right",

                    });

                    // console.log(response);
                }
            });

        });
    </script>


    <script>
        $('.btn-delete').on('click', function() {
            var subcatid = $(this).data('subcat2-id');
            // console.log(langid);
            if (confirm('Are you sure? you want to delete this Sub 2 category.')) {
                $.ajax({
                    type: "post",
                    url: "{{ route('ebooksub2.delete') }}",
                    data: {
                        _token: "{{ csrf_token() }}",
                        _method: "DELETE",
                        id: subcatid
                    },
                    success: function(response) {
                        $("#CatRow-" + subcatid).remove();
                        console.log(response);
                        toastr.success("", response.message, {
                            timeOut: 4000,
                            closeButton: !0,
                            newestOnTop: !0,
                            progressBar: !0,
                            positionClass: "toast-top-right",

                        });
                    },
                    error: function(xhr, status, error) {
                        var errors = xhr.responseJSON.errors;
                        var errorMessage = '';

                        // Construct error message
                        $.each(errors, function(key, value) {
                            errorMessage += value + '<br>';
                        });

                        toastr.error("", errorMessage, {
                            timeOut: 5000,
                            closeButton: !0,
                            debug: !1,
                            newestOnTop: !0,
                            progressBar: !0,
                            positionClass: "toast-top-right",

                        });

                        // console.log(response);
                    }
                });
            }
        });
    </script>
@endsection
