@extends('layout.default')



{{-- Content --}}
@section('content')
    <div class="container-fluid">

        <!-- row -->
        <div class="row">

            <div class="col-xl-12 col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">{{ $page_title }}</h4>
                    </div>
                    <div class="card-body">
                        <div class="basic-form">
                            <form id="updateform">
                                @csrf
                                <div class="form-row">
                                    <input type="hidden" name="id" value="{{ $data->id }}">
                                    <div class="form-group col-md-6 mb-2">
                                        <label for="language_id">Language*</label>
                                        <select name="language_id" id="language_id" class="form-control">
                                            <option value="">Select Language</option>
                                            @foreach ($languages as $lang)
                                                <option value="{{ $lang->id }}"
                                                    @if ($data->language_id == $lang->id) selected @endif>
                                                    {{ $lang->language_name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="form-group col-md-6 mb-2">
                                        <label for="category_id">Category*</label>
                                        <select name="category_id" id="category_id" class="form-control">
                                            <option value="">Select Category</option>
                                            @foreach ($maincategory as $cat)
                                                <option value="{{ $cat->id }}"
                                                    @if ($data->category_id == $cat->id) selected @endif>
                                                    {{ $cat->category_name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="form-group col-md-6 mb-2">
                                        <label for="subcategory_id">Sub Category</label>
                                        <select name="subcategory_id" id="subcategory_id" class="form-control">
                                            <option value="">Select SubCategory</option>
                                            @foreach ($subcategory as $subcat)
                                                <option value="{{ $subcat->id }}"
                                                    @if ($data->subcategory_id == $subcat->id) selected @endif>
                                                    {{ $subcat->subcategory_name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="form-group col-md-6 mb-2">
                                        <label for="sub2category_id">Sub 2 Category</label>
                                        <select name="sub2category_id" id="sub2category_id" class="form-control">
                                            <option value="">Select Sub2 Category</option>
                                            @foreach ($sub2category as $subcat2)
                                                <option value="{{ $subcat2->id }}"
                                                    @if ($data->sub2category_id == $subcat2->id) selected @endif>
                                                    {{ $subcat2->sub2category_name }}</option>
                                            @endforeach
                                        </select>
                                    </div>

                                    <div class="form-group col-md-6 mb-2">
                                        <label for="title">Title*</label>
                                        <input type="text" name="title" id="title" value="{{ $data->title }}" class="form-control"
                                            placeholder="Enter Ebook title">
                                    </div>


                                    {{-- <div class="form-group col-md-6 mb-3">
                                        <label class="">Image (optional)</label>
                                        <div class="input-group">
                                            <div class="custom-file">
                                                <input type="file" name="image" class="form-control-file"
                                                    accept="image/*">
                                            </div>
                                            @if (!empty($data->image))
                                                <img src="{{ asset('/ebook/allebookimage/') . '/' . $data->image }}"
                                                    width="100px" height='80px'>
                                            @endif
                                        </div>
                                    </div> --}}

                                    <div class="form-group col-md-3 mb-3 ">
                                        <label class="">Add Pdf*</label>
                                        <div class="input-group">
                                            <div class="">
                                                <input type="file" name="ebookpdf"
                                                    accept="pdf/docx">
                                            </div>
                                            @if (!empty($data->ebookpdf))
                                            <div>
                                                <a href="{{ asset('ebook/allebook') . '/' . $data->ebookpdf }}"
                                                    target="blank" class="btn btn-rounded btn-xs btn-warning my-1 text-white"><span
                                                        class="btn-icon-left text-warning"><i
                                                            class="fa fa-download color-warning"></i>
                                                    </span>Download</a>
                                            </div>

                                            @endif

                                        </div>

                                    </div>

                                </div>
                                <div class="form-group row mt-4">
                                    <div class="col-sm-10 m-auto">
                                        <button type="submit" class="btn btn-primary btn-block">Submit</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
    <script>
        $('#updateform').submit(function(event) {
            event.preventDefault();
            var formData = new FormData(this);
            // console.log(formData)
            $.ajax({
                type: "POST",
                url: "{{ route('ebook.update') }}",
                data: formData,
                cache: false,
                contentType: false,
                processData: false,
                success: function(response) {
                    // console.log(response);
                    toastr.success("", response.message, {
                        timeOut: 4000,
                        closeButton: !0,
                        newestOnTop: !0,
                        progressBar: !0,
                        positionClass: "toast-top-right",

                    });
                },
                error: function(xhr, status, error) {
                    var errors = xhr.responseJSON.errors;
                    var errorMessage = '';

                    // Construct error message
                    $.each(errors, function(key, value) {
                        errorMessage += value + '<br>';
                    });

                    toastr.error("", errorMessage, {
                        timeOut: 5000,
                        closeButton: !0,
                        debug: !1,
                        newestOnTop: !0,
                        progressBar: !0,
                        positionClass: "toast-top-right",

                    });

                    // console.log(response);
                }
            });

        });
    </script>
@endsection
