@extends('layout.default')



{{-- Content --}}
@section('content')
    <div class="container-fluid">

        <!-- row -->
        <div class="row">

            <div class="col-xl-12 col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">{{ $page_title }}</h4>
                    </div>
                    <div class="card-body">
                        <div class="basic-form">
                            <form id="addform">
                                @csrf
                                <div class="form-row">

                                    <div class="form-group col-md-3 mb-2">
                                        <label for="language_id">Language*</label>
                                        <select name="language_id" id="language_id" class="form-control">
                                            <option value="">Select Language</option>
                                            @foreach ($languages as $lang)
                                                <option value="{{ $lang->id }}">{{ $lang->language_name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="form-group col-md-3 mb-2">
                                        <label for="category_id">Category*</label>
                                        <select name="category_id" id="category_id" class="form-control">
                                            <option value="">Select Category</option>
                                            @foreach ($maincategory as $cat)
                                                <option value="{{ $cat->id }}">{{ $cat->category_name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="form-group col-md-3 mb-2">
                                        <label for="subcategory_id">Sub Category</label>
                                        <select name="subcategory_id" id="subcategory_id" class="form-control">
                                            <option value="">Select SubCategory</option>
                                            @foreach ($subcategory as $subcat)
                                                <option value="{{ $subcat->id }}">{{ $subcat->subcategory_name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="form-group col-md-3 mb-2">
                                        <label for="sub2category_id">Sub 2 Category</label>
                                        <select name="sub2category_id" id="sub2category_id" class="form-control">
                                            <option value="">Select Sub2 Category</option>
                                            @foreach ($sub2category as $subcat)
                                                <option value="{{ $subcat->id }}">{{ $subcat->sub2category_name }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>

                                    <div class="form-group col-md-12 mb-2">
                                        <label for="comment">Question*</label>
                                        <textarea class="form-control" required rows="2" name="question" id="comment"
                                            placeholder="Enter qustion here..."></textarea>
                                    </div>

                                    <div class="form-group col-md-6 mb-2">
                                        <label for="first">Option 1st*</label>
                                        <input type="text" name="one" id="first" required class="form-control"
                                            placeholder="Enter 1st option answer">
                                    </div>

                                    <div class="form-group col-md-6 mb-2">
                                        <label for="second">Option 2nd*</label>
                                        <input type="text" required name="two" id="second" class="form-control"
                                            placeholder="Enter 2nd option answer">
                                    </div>

                                    <div class="form-group col-md-6 mb-2">
                                        <label for="third">Option 3rd*</label>
                                        <input type="text" name="three" id="third" required class="form-control"
                                            placeholder="Enter 3rd option answer">
                                    </div>

                                    <div class="form-group col-md-6 mb-2">
                                        <label for="four">Option 4th*</label>
                                        <input type="text" name="four" id="four" required class="form-control"
                                            placeholder="Enter 4th option answer">
                                    </div>

                                    <div class="form-group col-md-6 mb-2">
                                        <label for="answer">Answer*</label>
                                        <select name="answer" id="answer" required class="form-control">
                                            <option value="">Select Answer</option>
                                            <option value="one">1st</option>
                                            <option value="two">2nd</option>
                                            <option value="three">3rd</option>
                                            <option value="four">4th</option>
                                        </select>
                                    </div>

                                    {{-- <div class="form-group col-md-6 mb-3">
                                        <label class="">Image (optional)</label>
                                        <div class="input-group">
                                            <div class="custom-file">
                                                <input type="file" name="image" class="form-control-file"
                                                    accept="image/*">

                                            </div>
                                        </div>
                                    </div> --}}

                                </div>
                                <div class="form-group row mt-4">
                                    <div class="col-sm-10 m-auto">
                                        <button type="submit" class="btn btn-primary btn-block">Submit</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
    <script>
        $('#addform').submit(function(event) {
            event.preventDefault();
            var formData = new FormData(this);
            // console.log(formData)
            $.ajax({
                type: "POST",
                url: "{{ route('quizquestion.store') }}",
                data: formData,
                cache: false,
                contentType: false,
                processData: false,
                success: function(response) {

                    $('#addform').find('input[type="text"]').val('');
                    // Reset select elements
                    $('#addform').find('select').prop('selectedIndex', 0);
                    // console.log(response);
                    toastr.success("", response.message, {
                        timeOut: 4000,
                        closeButton: !0,
                        newestOnTop: !0,
                        progressBar: !0,
                        positionClass: "toast-top-right",
                    });
                    window.location.reload();
                },
                error: function(xhr, status, error) {
                    var errors = xhr.responseJSON.errors;
                    var errorMessage = '';

                    // Construct error message
                    $.each(errors, function(key, value) {
                        errorMessage += value + '<br>';
                    });

                    toastr.error("", errorMessage, {
                        timeOut: 5000,
                        closeButton: !0,
                        debug: !1,
                        newestOnTop: !0,
                        progressBar: !0,
                        positionClass: "toast-top-right",

                    });

                    // console.log(response);
                }
            });

        });
    </script>
@endsection
