@extends('layout.default')



{{-- Content --}}
@section('content')
    <div class="container-fluid">

        <!-- row -->
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">{{ $page_title }}</h4>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table id="example" class="display min-w850">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Language Name</th>
                                        <th>Category Name</th>
                                        <th>SubCategory Name</th>
                                        <th>Sub2Category Name</th>
                                        <th>Question</th>
                                        <th>Answer</th>
                                        {{-- <th>Image</th> --}}
                                        <th>Status</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($data as $key => $ques)
                                        <tr id="CatRow-{{ $ques->id }}">
                                            <td>{{ $key + 1 }}</td>
                                            <td>{{ $ques->languages->language_name ?? '' }}</td>
                                            <td>{{ $ques->quizcategory->category_name ?? '' }}</td>
                                            <td>{{ $ques->quizsubcategory->subcategory_name ?? '' }}</td>
                                            <td>{{ $ques->quizsub2category->sub2category_name ?? '' }}</td>
                                            <td>{{ $ques->question ?? '' }}</td>
                                            <td>{{ $ques->answer ?? '' }}</td>
                                            {{-- @if (isset($ques['image']))
                                                <td>
                                                    <img src="{{ asset('/quiz/question/' . $ques['image']) }}"
                                                        width='80%' height='80px' alt="">
                                                </td>
                                            @else
                                                <td></td>
                                            @endif --}}
                                            <td>
                                                <div class="custom-control custom-checkbox mb-3 checkbox-warning check-xl">
                                                    <input type="checkbox" class="custom-control-input btn-status"
                                                        id="check-{{ $ques->id }}" data-catid="{{ $ques->id }}"
                                                        {{ $ques->status ? 'checked' : '' }}>
                                                    <label class="custom-control-label"
                                                        for="check-{{ $ques->id }}"></label>
                                                </div>
                                            </td>
                                            <td>
                                                <div class="d-flex">
                                                    <a  href="{{ route('quizquestion.edit', $ques->id) }}"
                                                        class="btn btn-primary shadow btn-xs sharp mr-1 btn-edit text-white"><i
                                                            class="fa fa-pencil"></i></a>
                                                    <a  class="btn btn-danger shadow btn-xs sharp btn-delete text-white"
                                                        data-ques-id="{{ $ques->id }}"><i
                                                            class="fa fa-trash"></i></a>
                                                </div>
                                            </td>

                                        </tr>
                                    @endforeach
                                </tbody>

                            </table>


                        </div>
                    </div>
                </div>
            </div>


        </div>
    </div>
@endsection


@section('scripts')
<script>
    $('.btn-status').on('click', function() {
        var catId = $(this).data('catid');
        var status = $(this).is(':checked') ? 1 : 0;
        // console.log(status);
        $.ajax({
            type: "post",
            url: "{{ route('quizquestion.status') }}",
            data: {
                _token: "{{ csrf_token() }}",
                id: catId,
                status: status
            },
            success: function(response) {

                // console.log(response);
                toastr.success("", response.message, {
                    timeOut: 4000,
                    closeButton: !0,
                    newestOnTop: !0,
                    progressBar: !0,
                    positionClass: "toast-top-right",

                });
            },
            error: function(xhr, status, error) {
                var errors = xhr.responseJSON.errors;
                var errorMessage = '';

                // Construct error message
                $.each(errors, function(key, value) {
                    errorMessage += value + '<br>';
                });

                toastr.error("", errorMessage, {
                    timeOut: 5000,
                    closeButton: !0,
                    debug: !1,
                    newestOnTop: !0,
                    progressBar: !0,
                    positionClass: "toast-top-right",

                });

                // console.log(response);
            }
        });

    });
</script>

<script>
    $('.btn-delete').on('click', function() {
        var subcatid = $(this).data('ques-id');
        // console.log(langid);
        if (confirm('Are you sure? you want to delete this Question.')) {
            $.ajax({
                type: "post",
                url: "{{ route('quizquestion.delete') }}",
                data: {
                    _token: "{{ csrf_token() }}",
                    _method: "DELETE",
                    id: subcatid
                },
                success: function(response) {
                    $("#CatRow-" + subcatid).remove();
                    console.log(response);
                    toastr.success("", response.message, {
                        timeOut: 4000,
                        closeButton: !0,
                        newestOnTop: !0,
                        progressBar: !0,
                        positionClass: "toast-top-right",

                    });
                },
                error: function(xhr, status, error) {
                    var errors = xhr.responseJSON.errors;
                    var errorMessage = '';

                    // Construct error message
                    $.each(errors, function(key, value) {
                        errorMessage += value + '<br>';
                    });

                    toastr.error("", errorMessage, {
                        timeOut: 5000,
                        closeButton: !0,
                        debug: !1,
                        newestOnTop: !0,
                        progressBar: !0,
                        positionClass: "toast-top-right",

                    });

                    // console.log(response);
                }
            });
        }
    });
</script>
@endsection
