<?php

use App\Http\Controllers\API\ApiController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:api')->get('/user', function (Request $request) {
    return $request->user();
});

Route::controller(ApiController::class)->group(function () {
    Route::get('language/{id?}', 'language');
    Route::get('banner', 'banner');
    // Quiz Section
    Route::get('quizcategory/{id?}', 'quizcategory');
    Route::get('quizsubcategory/{id?}', 'quizsubcategory');
    Route::get('quizsub2category/{id?}', 'quizsub2category');
    Route::get('quizquestion/{id?}', 'quizquestion');

    // Ebook Section
    Route::get('ebookcategory/{id?}', 'ebookcategory');
    Route::get('ebooksubcategory/{id?}', 'ebooksubcategory');
    Route::get('ebooksub2category/{id?}', 'ebooksub2category');
    Route::get('ebook/{id?}', 'ebook');

    // Daily News Section
    Route::get('dailycategory/{id?}', 'dailycategory');
    Route::get('dailynews/{id?}', 'dailynews');

    // Current Affair Section
    Route::get('currentcategory/{id?}', 'currentcategory');
    Route::get('currentsubcategory/{id?}', 'currentsubcategory');
    Route::get('currentaffair/{id?}', 'currentaffair');

    // Question/Answer Section
    Route::get('questcategory/{id?}', 'questcategory');
    Route::get('questsubcategory/{id?}', 'questsubcategory');
    Route::get('question/{id?}', 'questionAns');

    // Exam Prepration Section
    Route::get('examcategory/{id?}', 'examcategory');
    Route::get('examsubcategory/{id?}', 'examsubcategory');
    Route::get('examsub2category/{id?}', 'examsub2category');
    Route::get('examquestion/{id?}', 'examquestion');

});
