<?php

use App\Http\Controllers\Admin\AssignRoleController;
use App\Http\Controllers\Admin\BannerController;
use App\Http\Controllers\Admin\ChangePassController;
use App\Http\Controllers\Admin\CurrentAffairController;
use App\Http\Controllers\Admin\CurrentCategoryController;
use App\Http\Controllers\Admin\CurrentSubCategoryController;
use App\Http\Controllers\Admin\DailyMainCategoryController;
use App\Http\Controllers\Admin\DailyNewsController;
use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\Admin\EbookController;
use App\Http\Controllers\Admin\LanguageController;
use App\Http\Controllers\Admin\QuizMainCategoryController;
use App\Http\Controllers\Admin\QuizQuestionController;
use App\Http\Controllers\Admin\QuizSub2CategoryController;
use App\Http\Controllers\Admin\QuizSubCategoryController;

use App\Http\Controllers\Admin\EbookMainCategoryController;
use App\Http\Controllers\Admin\EbookQuestionController;
use App\Http\Controllers\Admin\EbookSub2CategoryController;
use App\Http\Controllers\Admin\EbookSubCategoryController;
use App\Http\Controllers\Admin\ExamController;
use App\Http\Controllers\Admin\ExamMainCategoryController;
use App\Http\Controllers\Admin\ExamSub2CategoryController;
use App\Http\Controllers\Admin\ExamSubCategoryController;
use App\Http\Controllers\Admin\QuestionAnsController;
use App\Http\Controllers\Admin\QuestMainCategoryController;
use App\Http\Controllers\Admin\QuestSubCategoryController;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Auth;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('auth.login');
});

Route::group(['Middleware' => ['auth']], function () {

    Route::get('dashboard', [DashboardController::class, 'index'])->name('dashboard');

    Route::controller(QuizQuestionController::class)->group(function () {
        Route::get('question', 'quiz_index')->name('quizquestion.index');
        Route::get('question-create', 'quiz_create')->name('quizquestion.create');
        Route::get('question-edit/{id}', 'quiz_edit')->name('quizquestion.edit');
        Route::post('question-store', 'store')->name('quizquestion.store');
        Route::post('question-status', 'status')->name('quizquestion.status');
        Route::post('question-update', 'update')->name('quizquestion.update');
        Route::delete('question-destroy', 'destroy')->name('quizquestion.delete');
    });


    Route::controller(EbookController::class)->group(function () {
        Route::get('ebooks', 'ebook_index')->name('ebook.index');
        Route::get('/ebooks-create', 'ebook_create')->name('ebook.create');
        Route::get('ebooks-edit/{id}', 'ebook_edit')->name('ebook.edit');
        Route::post('ebooks-store', 'store')->name('ebook.store');
        Route::post('ebooks-status', 'status')->name('ebook.status');
        Route::post('ebooks-update', 'update')->name('ebook.update');
        Route::delete('ebooks-destroy', 'destroy')->name('ebook.delete');
    });


    Route::controller(DailyNewsController::class)->group(function () {
        Route::get('daily-news', 'dailynews_index')->name('dailynews.index');
        Route::get('/daily-news-create', 'dailynews_create')->name('dailynews.create');
        Route::get('daily-news-edit/{id}', 'dailynews_edit')->name('dailynews.edit');
        Route::post('daily-news-store', 'store')->name('dailynews.store');
        Route::post('daily-news-status', 'status')->name('dailynews.status');
        Route::post('daily-news-update', 'update')->name('dailynews.update');
        Route::delete('daily-news-destroy', 'destroy')->name('dailynews.delete');
    });



    Route::controller(CurrentAffairController::class)->group(function () {
        Route::get('current-affair', 'current_index')->name('current.index');
        Route::get('/current-affair-create', 'current_create')->name('current.create');
        Route::get('current-affair-edit/{id}', 'current_edit')->name('current.edit');
        Route::post('current-affair-store', 'store')->name('current.store');
        Route::post('current-affair-status', 'status')->name('current.status');
        Route::post('current-affair-update', 'update')->name('current.update');
        Route::delete('current-affair-destroy', 'destroy')->name('current.delete');
    });


    Route::controller(QuestionAnsController::class)->group(function () {
        Route::get('question-answer', 'quest_index')->name('quest.index');
        Route::get('question-answer-create', 'quest_create')->name('quest.create');
        Route::get('question-answer-edit/{id}', 'quest_edit')->name('quest.edit');
        Route::post('question-answer-store', 'store')->name('quest.store');
        Route::post('question-answer-status', 'status')->name('quest.status');
        Route::post('question-answer-update', 'update')->name('quest.update');
        Route::delete('question-answer-destroy', 'destroy')->name('quest.delete');
    });


    Route::controller(ExamController::class)->group(function () {
        Route::get('exams', 'exam_index')->name('exam.index');
        Route::get('exams-create', 'exam_create')->name('exam.create');
        Route::get('exams-edit/{id}', 'exam_edit')->name('exam.edit');
        Route::post('exams-store', 'store')->name('exam.store');
        Route::post('exams-status', 'status')->name('exam.status');
        Route::post('exams-update', 'update')->name('exam.update');
        Route::delete('exams-destroy', 'destroy')->name('exam.delete');
    });

    Route::middleware('can:onlyadmin')->group(function () {


        Route::controller(LanguageController::class)->group(function () {
            Route::get('/language', 'lang_index')->name('lang.index');
            Route::post('/language-store', 'lang_store')->name('lang.store');
            Route::post('language-status', 'lang_status')->name('lang.status');
            Route::post('language-update', 'lang_update')->name('lang.update');
            Route::delete('language-destroy', 'destroy')->name('lang.delete');
        });

        Route::controller(QuizMainCategoryController::class)->group(function () {
            Route::get('main-category', 'quizmain_index')->name('quizmain.index');
            Route::post('main-category-store', 'store')->name('quizmain.store');
            Route::get('main-category-data', 'data')->name('quizmain.data');
            Route::post('main-category-status', 'status')->name('quizmain.status');
            Route::post('main-category-update', 'update')->name('quizmain.update');
            Route::delete('main-category-destroy', 'destroy')->name('quizmain.delete');
        });

        Route::controller(QuizSubCategoryController::class)->group(function () {
            Route::get('sub-category', 'quizsub_index')->name('quizsub.index');
            Route::post('sub-category-store', 'store')->name('quizsub.store');
            Route::get('sub-category-data', 'data')->name('quizsub.data');
            Route::post('sub-category-status', 'status')->name('quizsub.status');
            Route::post('sub-category-update', 'update')->name('quizsub.update');
            Route::delete('sub-category-destroy', 'destroy')->name('quizsub.delete');
        });

        Route::controller(QuizSub2CategoryController::class)->group(function () {
            Route::get('sub2-category', 'quizsub2_index')->name('quizsub2.index');
            Route::post('sub2-category-store', 'store')->name('quizsub2.store');
            Route::get('sub2-category-data', 'data')->name('quizsub2.data');
            Route::post('sub2-category-status', 'status')->name('quizsub2.status');
            Route::post('sub2-category-update', 'update')->name('quizsub2.update');
            Route::delete('sub2-category-destroy', 'destroy')->name('quizsub2.delete');
        });


        Route::controller(EbookMainCategoryController::class)->group(function () {
            Route::get('ebook-main-category', 'ebookmain_index')->name('ebookmain.index');
            Route::post('ebook-main-category-store', 'store')->name('ebookmain.store');
            Route::get('ebook-main-category-data', 'data')->name('ebookmain.data');
            Route::post('ebook-main-category-status', 'status')->name('ebookmain.status');
            Route::post('ebook-main-category-update', 'update')->name('ebookmain.update');
            Route::delete('ebook-main-category-destroy', 'destroy')->name('ebookmain.delete');
        });

        Route::controller(EbookSubCategoryController::class)->group(function () {
            Route::get('ebook-sub-category', 'ebooksub_index')->name('ebooksub.index');
            Route::post('ebook-sub-category-store', 'store')->name('ebooksub.store');
            Route::get('ebook-sub-category-data', 'data')->name('ebooksub.data');
            Route::post('ebook-sub-category-status', 'status')->name('ebooksub.status');
            Route::post('ebook-sub-category-update', 'update')->name('ebooksub.update');
            Route::delete('ebook-sub-category-destroy', 'destroy')->name('ebooksub.delete');
        });

        Route::controller(EbookSub2CategoryController::class)->group(function () {
            Route::get('ebook-sub2-category', 'ebooksub2_index')->name('ebooksub2.index');
            Route::post('ebook-sub2-category-store', 'store')->name('ebooksub2.store');
            Route::get('ebook-sub2-category-data', 'data')->name('ebooksub2.data');
            Route::post('ebook-sub2-category-status', 'status')->name('ebooksub2.status');
            Route::post('ebook-sub2-category-update', 'update')->name('ebooksub2.update');
            Route::delete('ebook-sub2-category-destroy', 'destroy')->name('ebooksub2.delete');
        });

        Route::controller(DailyMainCategoryController::class)->group(function () {
            Route::get('news-main-category', 'dailymain_index')->name('dailymain.index');
            Route::post('news-main-category-store', 'store')->name('dailymain.store');
            Route::get('news-main-category-data', 'data')->name('dailymain.data');
            Route::post('news-main-category-status', 'status')->name('dailymain.status');
            Route::post('news-main-category-update', 'update')->name('dailymain.update');
            Route::delete('news-main-category-destroy', 'destroy')->name('dailymain.delete');
        });


        Route::controller(CurrentCategoryController::class)->group(function () {
            Route::get('current-affair-category', 'currentmain_index')->name('currentmain.index');
            Route::post('current-affair-category-store', 'store')->name('currentmain.store');
            Route::get('current-affair-category-data', 'data')->name('currentmain.data');
            Route::post('current-affair-category-status', 'status')->name('currentmain.status');
            Route::post('current-affair-category-update', 'update')->name('currentmain.update');
            Route::delete('current-affair-category-destroy', 'destroy')->name('currentmain.delete');
        });

        Route::controller(CurrentSubCategoryController::class)->group(function () {
            Route::get('current-affair-subcategory', 'currentsub_index')->name('currentsub.index');
            Route::post('current-affair-subcategory-store', 'store')->name('currentsub.store');
            Route::get('current-affair-subcategory-data', 'data')->name('currentsub.data');
            Route::post('current-affair-subcategory-status', 'status')->name('currentsub.status');
            Route::post('current-affair-subcategory-update', 'update')->name('currentsub.update');
            Route::delete('current-affair-subcategory-destroy', 'destroy')->name('currentsub.delete');
        });

        Route::controller(BannerController::class)->group(function () {
            Route::get('banner', 'banners_index')->name('banners.index');
            Route::post('banners-store', 'store')->name('banners.store');
            Route::get('banners-data', 'data')->name('banners.data');
            Route::post('banners-status', 'status')->name('banners.status');
            Route::post('banners-update', 'update')->name('banners.update');
            Route::delete('banners-destroy', 'destroy')->name('banners.delete');
        });

        Route::controller(QuestMainCategoryController::class)->group(function () {
            Route::get('question-ans-category', 'questmain_index')->name('questmain.index');
            Route::post('question-ans-category-store', 'store')->name('questmain.store');
            Route::get('question-ans-category-data', 'data')->name('questmain.data');
            Route::post('question-ans-category-status', 'status')->name('questmain.status');
            Route::post('question-ans-category-update', 'update')->name('questmain.update');
            Route::delete('question-ans-category-destroy', 'destroy')->name('questmain.delete');
        });

        Route::controller(QuestSubCategoryController::class)->group(function () {
            Route::get('question-ans-subcategory', 'questsub_index')->name('questsub.index');
            Route::post('question-ans-subcategory-store', 'store')->name('questsub.store');
            Route::get('question-ans-subcategory-data', 'data')->name('questsub.data');
            Route::post('question-ans-subcategory-status', 'status')->name('questsub.status');
            Route::post('question-ans-subcategory-update', 'update')->name('questsub.update');
            Route::delete('question-ans-subcategory-destroy', 'destroy')->name('questsub.delete');
        });


        Route::controller(ExamMainCategoryController::class)->group(function () {
            Route::get('exam-category', 'examain_index')->name('examain.index');
            Route::post('exam-category-store', 'store')->name('examain.store');
            Route::get('exam-category-data', 'data')->name('examain.data');
            Route::post('exam-category-status', 'status')->name('examain.status');
            Route::post('exam-category-update', 'update')->name('examain.update');
            Route::delete('exam-category-destroy', 'destroy')->name('examain.delete');
        });

        Route::controller(ExamSubCategoryController::class)->group(function () {
            Route::get('exam-subcategory', 'examsub_index')->name('examsub.index');
            Route::post('exam-subcategory-store', 'store')->name('examsub.store');
            Route::get('exam-subcategory-data', 'data')->name('examsub.data');
            Route::post('exam-subcategory-status', 'status')->name('examsub.status');
            Route::post('exam-subcategory-update', 'update')->name('examsub.update');
            Route::delete('exam-subcategory-destroy', 'destroy')->name('examsub.delete');
        });

        Route::controller(ExamSub2CategoryController::class)->group(function () {
            Route::get('exam-sub2category', 'examsub2_index')->name('examsub2.index');
            Route::post('exam-sub2category-store', 'store')->name('examsub2.store');
            Route::get('exam-sub2category-data', 'data')->name('examsub2.data');
            Route::post('exam-sub2category-status', 'status')->name('examsub2.status');
            Route::post('exam-sub2category-update', 'update')->name('examsub2.update');
            Route::delete('exam-sub2category-destroy', 'destroy')->name('examsub2.delete');
        });

        Route::controller(AssignRoleController::class)->group(function () {
            Route::get('roles', 'role_index')->name('role.index');
            Route::get('assign-role', 'role_create')->name('role.create');
            Route::post('assign-store', 'store')->name('role.store');
            Route::post('assign-status', 'status')->name('role.status');
            Route::delete('role-destroy', 'destroy')->name('role.delete');
        });
    });


    Route::get('change-password', [ChangePassController::class, 'password_update'])->name('admin.updatepass');
    Route::post('change-password', [ChangePassController::class, 'change_password'])->name('admin.password');

    // Route::controller(EmployeeController::class)->group(function () {
    //     Route::get('employee', 'index')->name('employee.index');
    //     Route::get('new-employee', 'create')->name('employee.create');
    //     Route::post('employee-store', 'store')->name('employee.store');
    //     Route::post('employee-status', 'status')->name('employee.status');
    //     Route::get('employee-edit/{id}', 'edit')->name('employee.edit');
    //     Route::get('employee-view/{id}', 'view')->name('employee.view');
    //     Route::post('employee-update', 'update')->name('employee.update');
    //     Route::delete('employee-destroy', 'destroy')->name('employee.delete');
    //     Route::match(['GET', 'PUT', 'PATCH'], '/updatePhaseStatus/{phase}', 'updateStatus')->name('update.phase.status');

});


//Route::get('/', 'App\Http\Controllers\ChrevadminController@dashboard_1');
Route::get('/index', 'App\Http\Controllers\ChrevadminController@dashboard_1');
Route::get('/coin-details', 'App\Http\Controllers\ChrevadminController@coin_details');
Route::get('/market-capital', 'App\Http\Controllers\ChrevadminController@market_capital');
Route::get('/my-wallet', 'App\Http\Controllers\ChrevadminController@my_wallet');
Route::get('/portfolio', 'App\Http\Controllers\ChrevadminController@portfolio');
Route::get('/transactions', 'App\Http\Controllers\ChrevadminController@transactions');
Route::get('/app-calender', 'App\Http\Controllers\ChrevadminController@app_calender');
Route::get('/app-profile', 'App\Http\Controllers\ChrevadminController@app_profile');
Route::get('/chart-chartist', 'App\Http\Controllers\ChrevadminController@chart_chartist');
Route::get('/chart-chartjs', 'App\Http\Controllers\ChrevadminController@chart_chartjs');
Route::get('/chart-flot', 'App\Http\Controllers\ChrevadminController@chart_flot');
Route::get('/chart-morris', 'App\Http\Controllers\ChrevadminController@chart_morris');
Route::get('/chart-peity', 'App\Http\Controllers\ChrevadminController@chart_peity');
Route::get('/chart-sparkline', 'App\Http\Controllers\ChrevadminController@chart_sparkline');
Route::get('/ecom-checkout', 'App\Http\Controllers\ChrevadminController@ecom_checkout');
Route::get('/ecom-customers', 'App\Http\Controllers\ChrevadminController@ecom_customers');
Route::get('/ecom-invoice', 'App\Http\Controllers\ChrevadminController@ecom_invoice');
Route::get('/ecom-product-detail', 'App\Http\Controllers\ChrevadminController@ecom_product_detail');
Route::get('/ecom-product-grid', 'App\Http\Controllers\ChrevadminController@ecom_product_grid');
Route::get('/ecom-product-list', 'App\Http\Controllers\ChrevadminController@ecom_product_list');
Route::get('/ecom-product-order', 'App\Http\Controllers\ChrevadminController@ecom_product_order');
Route::get('/email-compose', 'App\Http\Controllers\ChrevadminController@email_compose');
Route::get('/email-inbox', 'App\Http\Controllers\ChrevadminController@email_inbox');
Route::get('/email-read', 'App\Http\Controllers\ChrevadminController@email_read');
Route::get('/form-editor-summernote', 'App\Http\Controllers\ChrevadminController@form_editor_summernote');
Route::get('/form-element', 'App\Http\Controllers\ChrevadminController@form_element');
Route::get('/form-pickers', 'App\Http\Controllers\ChrevadminController@form_pickers');
Route::get('/form-validation-jquery', 'App\Http\Controllers\ChrevadminController@form_validation_jquery');
Route::get('/form-wizard', 'App\Http\Controllers\ChrevadminController@form_wizard');
Route::get('/map-jqvmap', 'App\Http\Controllers\ChrevadminController@map_jqvmap');
Route::get('/page-error-400', 'App\Http\Controllers\ChrevadminController@page_error_400');
Route::get('/page-error-403', 'App\Http\Controllers\ChrevadminController@page_error_403');
Route::get('/page-error-404', 'App\Http\Controllers\ChrevadminController@page_error_404');
Route::get('/page-error-500', 'App\Http\Controllers\ChrevadminController@page_error_500');
Route::get('/page-error-503', 'App\Http\Controllers\ChrevadminController@page_error_503');
Route::get('/page-forgot-password', 'App\Http\Controllers\ChrevadminController@page_forgot_password');
Route::get('/page-lock-screen', 'App\Http\Controllers\ChrevadminController@page_lock_screen');
Route::get('/page-login', 'App\Http\Controllers\ChrevadminController@page_login');
Route::get('/page-register', 'App\Http\Controllers\ChrevadminController@page_register');
Route::get('/table-bootstrap-basic', 'App\Http\Controllers\ChrevadminController@table_bootstrap_basic');
Route::get('/table-datatable-basic', 'App\Http\Controllers\ChrevadminController@table_datatable_basic');
Route::get('/uc-nestable', 'App\Http\Controllers\ChrevadminController@uc_nestable');
Route::get('/uc-noui-slider', 'App\Http\Controllers\ChrevadminController@uc_noui_slider');
Route::get('/uc-select2', 'App\Http\Controllers\ChrevadminController@uc_select2');
Route::get('/uc-sweetalert', 'App\Http\Controllers\ChrevadminController@uc_sweetalert');
Route::get('/uc-toastr', 'App\Http\Controllers\ChrevadminController@uc_toastr');
Route::get('/ui-accordion', 'App\Http\Controllers\ChrevadminController@ui_accordion');
Route::get('/ui-alert', 'App\Http\Controllers\ChrevadminController@ui_alert');
Route::get('/ui-badge', 'App\Http\Controllers\ChrevadminController@ui_badge');
Route::get('/ui-button', 'App\Http\Controllers\ChrevadminController@ui_button');
Route::get('/ui-button-group', 'App\Http\Controllers\ChrevadminController@ui_button_group');
Route::get('/ui-card', 'App\Http\Controllers\ChrevadminController@ui_card');
Route::get('/ui-carousel', 'App\Http\Controllers\ChrevadminController@ui_carousel');
Route::get('/ui-dropdown', 'App\Http\Controllers\ChrevadminController@ui_dropdown');
Route::get('/ui-grid', 'App\Http\Controllers\ChrevadminController@ui_grid');
Route::get('/ui-list-group', 'App\Http\Controllers\ChrevadminController@ui_list_group');
Route::get('/ui-media-object', 'App\Http\Controllers\ChrevadminController@ui_media_object');
Route::get('/ui-modal', 'App\Http\Controllers\ChrevadminController@ui_modal');
Route::get('/ui-pagination', 'App\Http\Controllers\ChrevadminController@ui_pagination');
Route::get('/ui-popover', 'App\Http\Controllers\ChrevadminController@ui_popover');
Route::get('/ui-progressbar', 'App\Http\Controllers\ChrevadminController@ui_progressbar');
Route::get('/ui-tab', 'App\Http\Controllers\ChrevadminController@ui_tab');
Route::get('/ui-typography', 'App\Http\Controllers\ChrevadminController@ui_typography');
Route::get('/widget-basic', 'App\Http\Controllers\ChrevadminController@widget_basic');
Auth::routes();


// Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');
