<?php $__env->startSection('content'); ?>
    <div class="container-fluid">

        <!-- row -->
        <div class="row">

            <div class="col-xl-12 col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Language</h4>
                    </div>
                    <div class="card-body">
                        <div class="basic-form">
                            <form id="addform">
                                <?php echo csrf_field(); ?>
                                <div class="form-row">
                                    <div class="col-sm-6">
                                        <input type="text" name="language_name" id="language_name" class="form-control"
                                            placeholder="Enter language name">
                                    </div>
                                    <div class="col-sm-6 mt-2 mt-sm-0">
                                        <button type="submit" class="btn btn-primary btn-block mb-2" id="submitButton">Submit</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>


            <div class="col-md-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">List Language</h4>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table id="example" class="display min-w850">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Language Name</th>
                                        <th>Status</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr id="CatRow-<?php echo e($lang->id); ?>">
                                            <td><?php echo e($key + 1); ?></td>
                                            <td><?php echo e($lang->language_name ?? ''); ?></td>
                                            <td>
                                                <div class="custom-control custom-checkbox mb-3 checkbox-warning check-xl">
                                                    <input type="checkbox" class="custom-control-input btn-status"
                                                        id="check-<?php echo e($lang->id); ?>" data-langid="<?php echo e($lang->id); ?>"
                                                        <?php echo e($lang->status ? 'checked' : ''); ?>>
                                                    <label class="custom-control-label"
                                                        for="check-<?php echo e($lang->id); ?>"></label>
                                                </div>
                                            </td>
                                            <td>
                                                <div class="d-flex">
                                                    <a data-lang-id="<?php echo e($lang->id); ?>"
                                                        data-lang-name="<?php echo e($lang->language_name); ?>"
                                                        class="btn btn-primary shadow btn-xs sharp mr-1 text-white btn-edit"><i
                                                            class="fa fa-pencil"></i></a>
                                                    <a class="btn btn-danger shadow btn-xs sharp text-white btn-delete"
                                                        data-lang-id="<?php echo e($lang->id); ?>"><i class="fa fa-trash"></i></a>
                                                </div>
                                            </td>

                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                                
                            </table>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>


    <!-- Small modal -->
    
    <div class="modal fade bd-example-modal-sm" tabindex="-1" id="editmodal" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-sm">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Update Language</h5>
                    <button type="button" class="close" data-dismiss="modal"><span>&times;</span>
                    </button>
                </div>
                <form id="updateform">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <input type="hidden" name="id" value="" id="langid" >
                        <input type="text" name="language_name" value=""  maxlength="30" class="form-control"
                            id="lang_name" placeholder="Language Name"
                            oninput="this.value = this.value.replace(/[^a-zA-Z .]/g, ''); this.value = this.value.replace(/(\..*)\./g, '$1');">
                    </div>
                    <div class="modal-footer">
                        
                        <button type="submit" class="btn btn-primary">Save changes</button>
                    </div>

                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script>
        $(document).ready(function() {

            $('.btn-edit').on('click', function() {
                // deliverButton = $(this); // Store a reference to the clicked button
                $('#editmodal').modal('show');
                let langId = $(this).data('lang-id');
                let langName = $(this).data('lang-name');
                console.log(langName);
                $("#langid").val(langId);
                $("#lang_name").val(langName);
                // // Clear input fields
                // $('#person_name').val('');
                // $('#person_mobile').val('');
                // $('#collection').val('');
                // $('#deliver_remark').val('');
            });
        });
    </script>

    <script>
        $('.btn-status').on('click', function() {
            var langId = $(this).data('langid');
            var status = $(this).is(':checked') ? 1 : 0;
            // console.log(status);
            $.ajax({
                type: "post",
                url: "<?php echo e(route('lang.status')); ?>",
                data: {
                    _token: "<?php echo e(csrf_token()); ?>",
                    id: langId,
                    status: status
                },
                success: function(response) {

                    // console.log(response);
                    toastr.success("", response.message, {
                        timeOut: 4000,
                        closeButton: !0,
                        newestOnTop: !0,
                        progressBar: !0,
                        positionClass: "toast-top-right",

                    });
                },
                error: function(xhr, status, error) {
                    var errors = xhr.responseJSON.errors;
                    var errorMessage = '';

                    // Construct error message
                    $.each(errors, function(key, value) {
                        errorMessage += value + '<br>';
                    });

                    toastr.error("", errorMessage, {
                        timeOut: 5000,
                        closeButton: !0,
                        debug: !1,
                        newestOnTop: !0,
                        progressBar: !0,
                        positionClass: "toast-top-right",

                    });

                    // console.log(response);
                }
            });

        });
    </script>
    <script>
        $('#addform').submit(function(event) {
            event.preventDefault();
            var formData = new FormData(this);
            // $('#submitButton').prop('disabled', true);
            // console.log(formData)
            $.ajax({
                type: "POST",
                url: "<?php echo e(route('lang.store')); ?>",
                data: formData,
                cache: false,
                contentType: false,
                processData: false,
                success: function(response) {

                    $('#language_name').val('');
                    // console.log(response);
                    toastr.success("", response.message, {
                        timeOut: 4000,
                        closeButton: !0,
                        newestOnTop: !0,
                        progressBar: !0,
                        positionClass: "toast-top-right",

                    });
                    window.location.reload();
                },
                error: function(xhr, status, error) {
                    var errors = xhr.responseJSON.errors;
                    var errorMessage = '';

                    // Construct error message
                    $.each(errors, function(key, value) {
                        errorMessage += value + '<br>';
                    });

                    toastr.error("", errorMessage, {
                        timeOut: 5000,
                        closeButton: !0,
                        debug: !1,
                        newestOnTop: !0,
                        progressBar: !0,
                        positionClass: "toast-top-right",

                    });

                    // console.log(response);
                }
            });

        });
    </script>

<script>
    $('#updateform').submit(function(event) {
        event.preventDefault();
        var formData = new FormData(this);
        // console.log(formData)
        $.ajax({
            type: "POST",
            url: "<?php echo e(route('lang.update')); ?>",
            data: formData,
            cache: false,
            contentType: false,
            processData: false,
            success: function(response) {
                // console.log(response);
                toastr.success("", response.message, {
                    timeOut: 4000,
                    closeButton: !0,
                    newestOnTop: !0,
                    progressBar: !0,
                    positionClass: "toast-top-right",

                });
            },
            error: function(xhr, status, error) {
                var errors = xhr.responseJSON.errors;
                var errorMessage = '';

                // Construct error message
                $.each(errors, function(key, value) {
                    errorMessage += value + '<br>';
                });

                toastr.error("", errorMessage, {
                    timeOut: 5000,
                    closeButton: !0,
                    debug: !1,
                    newestOnTop: !0,
                    progressBar: !0,
                    positionClass: "toast-top-right",

                });

                // console.log(response);
            }
        });

    });
</script>


    <script>
        $('.btn-delete').on('click', function() {
            var langid = $(this).data('lang-id');
            // console.log(langid);
            if (confirm('Are you sure? you want to delete this Language.')) {
                $.ajax({
                    type: "post",
                    url: "<?php echo e(route('lang.delete')); ?>",
                    data: {
                        _token: "<?php echo e(csrf_token()); ?>",
                        _method: "DELETE",
                        id: langid
                    },
                    success: function(response) {
                        $("#CatRow-" + langid).remove();
                        console.log(response);
                        toastr.success("", response.message, {
                            timeOut: 4000,
                            closeButton: !0,
                            newestOnTop: !0,
                            progressBar: !0,
                            positionClass: "toast-top-right",

                        });
                    },
                    error: function(xhr, status, error) {
                        var errors = xhr.responseJSON.errors;
                        var errorMessage = '';

                        // Construct error message
                        $.each(errors, function(key, value) {
                            errorMessage += value + '<br>';
                        });

                        toastr.error("", errorMessage, {
                            timeOut: 5000,
                            closeButton: !0,
                            debug: !1,
                            newestOnTop: !0,
                            progressBar: !0,
                            positionClass: "toast-top-right",

                        });

                        // console.log(response);
                    }
                });
            }
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Laravel\devquiz\resources\views/admin/language/index.blade.php ENDPATH**/ ?>