<?php $__env->startSection('content'); ?>
    <div class="container-fluid">

        <!-- row -->
        <div class="row">

            <div class="col-xl-12 col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title"><?php echo e($page_title); ?></h4>
                    </div>
                    <div class="card-body">
                        <div class="basic-form">
                            <form id="addform">
                                <?php echo csrf_field(); ?>
                                <div class="form-row">

                                    <div class="form-group col-md-6 mb-2">
                                        <label for="usertype">Role*</label>
                                        <select name="usertype" id="usertype" required class="form-control">
                                            <option value="">Select Role</option>
                                            <option value="admin">Admin</option>
                                            <option value="employee">Employee</option>
                                        </select>
                                    </div>


                                    <div class="form-group col-md-6 mb-2">
                                        <label for="name">Name*</label>
                                        <input type="text" name="username" id="name" required class="form-control"
                                            placeholder="Enter Name">
                                    </div>


                                    <div class="form-group col-md-6 mb-2">
                                        <label for="email">Email*</label>
                                        <input type="email" name="email" id="email" required class="form-control"
                                            placeholder="Enter Email">
                                    </div>

                                    <div class="form-group col-md-6 mb-2">
                                        <label for="password">Create Password*</label>
                                        <input type="password" name="password" id="password" required class="form-control"
                                            placeholder="Enter password">
                                    </div>

                                    


                                </div>
                                <div class="form-group row mt-4">
                                    <div class="col-sm-10 m-auto">
                                        <button type="submit" class="btn btn-primary btn-block">Submit</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script>
        $('#addform').submit(function(event) {
            event.preventDefault();
            var formData = new FormData(this);
            // console.log(formData)
            $('#addform').find('input[type="text"]').val('');
            $('#addform').find('input[type="email"]').val('');
            $('#addform').find('input[type="password"]').val('');
            // Reset select elements
            $('#addform').find('select').prop('selectedIndex', 0);
            $.ajax({
                type: "POST",
                url: "<?php echo e(route('role.store')); ?>",
                data: formData,
                cache: false,
                contentType: false,
                processData: false,
                success: function(response) {

                    $('#addform').find('input[type="text"]').val('');
                    $('#addform').find('input[type="email"]').val('');
                    $('#addform').find('input[type="password"]').val('');
                    // Reset select elements
                    $('#addform').find('select').prop('selectedIndex', 0);
                    // console.log(response);
                    toastr.success("", response.message, {
                        timeOut: 4000,
                        closeButton: !0,
                        newestOnTop: !0,
                        progressBar: !0,
                        positionClass: "toast-top-right",
                    });
                    window.location.reload();
                },
                error: function(xhr, status, error) {
                    var errors = xhr.responseJSON.errors;
                    var errorMessage = '';

                    // Construct error message
                    $.each(errors, function(key, value) {
                        errorMessage += value + '<br>';
                    });

                    toastr.error("", errorMessage, {
                        timeOut: 5000,
                        closeButton: !0,
                        debug: !1,
                        newestOnTop: !0,
                        progressBar: !0,
                        positionClass: "toast-top-right",

                    });

                    // console.log(response);
                }
            });

        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Laravel\devquiz\resources\views/admin/assign_role/create.blade.php ENDPATH**/ ?>