<?php $__env->startSection('content'); ?>
    <div class="container-fluid">

        <!-- row -->
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title"><?php echo e($page_title); ?></h4>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table id="example" class="display min-w850">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Language </th>
                                        <th>Category</th>
                                        <th>SubCategory</th>
                                        <th>Title</th>
                                        
                                        <th>Status</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $quest): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr id="CatRow-<?php echo e($quest->id); ?>">
                                            <td><?php echo e($key + 1); ?></td>
                                            <td><?php echo e($quest->languages->language_name ?? ''); ?></td>
                                            <td><?php echo e($quest->questcategory->category_name ?? ''); ?></td>
                                            <td><?php echo e($quest->questsubcategory->subcategory_name ?? ''); ?></td>
                                            <td><?php echo e($quest->title ?? ''); ?></td>
                                            
                                            <td>
                                                <div class="custom-control custom-checkbox mb-3 checkbox-warning check-xl">
                                                    <input type="checkbox" class="custom-control-input btn-status"
                                                        id="check-<?php echo e($quest->id); ?>" data-catid="<?php echo e($quest->id); ?>"
                                                        <?php echo e($quest->status ? 'checked' : ''); ?>>
                                                    <label class="custom-control-label"
                                                        for="check-<?php echo e($quest->id); ?>"></label>
                                                </div>
                                            </td>
                                            <td>
                                                <div class="d-flex">
                                                    <a href="<?php echo e(route('quest.edit', $quest->id)); ?>"
                                                        class="btn btn-primary shadow btn-xs sharp mr-1 btn-edit text-white"><i
                                                            class="fa fa-pencil"></i></a>
                                                    <a class="btn btn-danger shadow btn-xs sharp btn-delete text-white"
                                                        data-quest-id="<?php echo e($quest->id); ?>"><i class="fa fa-trash"></i></a>
                                                </div>
                                            </td>

                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>

                            </table>


                        </div>
                    </div>
                </div>
            </div>


        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>
    <script>
        $('.btn-status').on('click', function() {
            var catId = $(this).data('catid');
            var status = $(this).is(':checked') ? 1 : 0;
            // console.log(status);
            $.ajax({
                type: "post",
                url: "<?php echo e(route('quest.status')); ?>",
                data: {
                    _token: "<?php echo e(csrf_token()); ?>",
                    id: catId,
                    status: status
                },
                success: function(response) {

                    // console.log(response);
                    toastr.success("", response.message, {
                        timeOut: 4000,
                        closeButton: !0,
                        newestOnTop: !0,
                        progressBar: !0,
                        positionClass: "toast-top-right",

                    });
                },
                error: function(xhr, status, error) {
                    var errors = xhr.responseJSON.errors;
                    var errorMessage = '';

                    // Construct error message
                    $.each(errors, function(key, value) {
                        errorMessage += value + '<br>';
                    });

                    toastr.error("", errorMessage, {
                        timeOut: 5000,
                        closeButton: !0,
                        debug: !1,
                        newestOnTop: !0,
                        progressBar: !0,
                        positionClass: "toast-top-right",

                    });

                    // console.log(response);
                }
            });

        });
    </script>

    <script>
        $('.btn-delete').on('click', function() {
            var subcatid = $(this).data('quest-id');
            // console.log(langid);
            if (confirm('Are you sure? you want to delete this question.')) {
                $.ajax({
                    type: "post",
                    url: "<?php echo e(route('quest.delete')); ?>",
                    data: {
                        _token: "<?php echo e(csrf_token()); ?>",
                        _method: "DELETE",
                        id: subcatid
                    },
                    success: function(response) {
                        $("#CatRow-" + subcatid).remove();
                        console.log(response);
                        toastr.success("", response.message, {
                            timeOut: 4000,
                            closeButton: !0,
                            newestOnTop: !0,
                            progressBar: !0,
                            positionClass: "toast-top-right",

                        });
                    },
                    error: function(xhr, status, error) {
                        var errors = xhr.responseJSON.errors;
                        var errorMessage = '';

                        // Construct error message
                        $.each(errors, function(key, value) {
                            errorMessage += value + '<br>';
                        });

                        toastr.error("", errorMessage, {
                            timeOut: 5000,
                            closeButton: !0,
                            debug: !1,
                            newestOnTop: !0,
                            progressBar: !0,
                            positionClass: "toast-top-right",

                        });

                        // console.log(response);
                    }
                });
            }
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Laravel\devquiz\resources\views/admin/questionAnswer/index.blade.php ENDPATH**/ ?>