<?php $__env->startSection('content'); ?>
    <div class="container-fluid">

        <!-- row -->
        <div class="row">

            <div class="col-xl-12 col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title"><?php echo e($page_title); ?></h4>
                    </div>
                    <div class="card-body">
                        <div class="basic-form">
                            <form id="addform">
                                <?php echo csrf_field(); ?>
                                <div class="form-row">
                                    <div class="col-md-4 mb-2">
                                        <select name="language_id" id="" class="form-control">
                                            <option value="">Select Language</option>
                                            <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($cat->id); ?>"><?php echo e($cat->language_name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <div class="col-md-4 mb-2">
                                        <input type="text" name="category_name" id="category_name" class="form-control"
                                            placeholder="Enter category name">
                                    </div>

                                    <div class="col-md-3 mb-3">
                                        <div class="input-group">
                                            <div class="custom-file">
                                                <input type="file" name="image" class="custom-file-input"
                                                    accept="image/*" required>
                                                <label class="custom-file-label">Choose image</label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4 mb-2">
                                        <button type="submit" class="btn btn-primary btn-block">Submit</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>


            <div class="col-md-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Main Category List</h4>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table id="example" class="display min-w850">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Language Name</th>
                                        <th>Category Name</th>
                                        <th>Image</th>
                                        <th>Status</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr id="CatRow-<?php echo e($cat->id); ?>">
                                            <td><?php echo e($key + 1); ?></td>
                                            <td><?php echo e($cat->languages->language_name ?? ''); ?></td>
                                            <td><?php echo e($cat->category_name ?? ''); ?></td>
                                            <?php if(isset($cat['image'])): ?>
                                                <td>
                                                    <img src="<?php echo e(asset('/question/maincategory/' . $cat['image'])); ?>"
                                                        width='80%' height='80px' alt="">
                                                </td>
                                            <?php else: ?>
                                                <td></td>
                                            <?php endif; ?>
                                            <td>
                                                <div class="custom-control custom-checkbox mb-3 checkbox-warning check-xl">
                                                    <input type="checkbox" class="custom-control-input btn-status"
                                                        id="check-<?php echo e($cat->id); ?>" data-catid="<?php echo e($cat->id); ?>"
                                                        <?php echo e($cat->status ? 'checked' : ''); ?>>
                                                    <label class="custom-control-label"
                                                        for="check-<?php echo e($cat->id); ?>"></label>
                                                </div>
                                            </td>
                                            <td>
                                                <div class="d-flex">
                                                    <a  data-cat-id="<?php echo e($cat->id); ?>"
                                                        data-lang-id="<?php echo e($cat->language_id); ?>"
                                                        data-cat-name="<?php echo e($cat->category_name); ?>"
                                                        class="btn btn-primary shadow btn-xs sharp mr-1 btn-edit text-white"><i
                                                            class="fa fa-pencil"></i></a>
                                                    <a  class="btn btn-danger shadow btn-xs sharp text-white btn-delete"
                                                        data-cat-id="<?php echo e($cat->id); ?>"><i class="fa fa-trash"></i></a>
                                                </div>
                                            </td>

                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>

                            </table>


                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>


    
    <div class="modal fade" id="editmodal">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Edit Main Category</h5>
                    <button type="button" class="close" data-dismiss="modal"><span>&times;</span>
                    </button>
                </div>
                <form id="updateform">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <input type="hidden" name="id" value="" id="catid">
                        <div class="form-group">
                        <select name="language_id" id="lang_id" class="form-control">
                            <option value="">Select Language</option>
                            <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($lang->id); ?>"><?php echo e($lang->language_name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        </div>
                        <br>
                        <input type="text" name="category_name" value="" maxlength="30" class="form-control"
                            id="cat_name" placeholder="Category Name"
                            oninput="this.value = this.value.replace(/[^a-zA-Z .]/g, ''); this.value = this.value.replace(/(\..*)\./g, '$1');">
                    </div>
                    <div class="modal-footer">
                        
                        <button type="submit" class="btn btn-primary">Save changes</button>
                    </div>

                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script>
        $(document).ready(function() {

            $('.btn-edit').on('click', function() {

                $('#editmodal').modal('show');
                let catId = $(this).data('cat-id');
                let catName = $(this).data('cat-name');
                let langid = $(this).data('lang-id');
                $("#catid").val(catId);
                $("#cat_name").val(catName);
                $('#editmodal select[id="lang_id"]').find('option[value="' + langid + '"]').prop('selected',
                    true);
            });
        });
    </script>

    <script>
        $('.btn-status').on('click', function() {
            var catId = $(this).data('catid');
            var status = $(this).is(':checked') ? 1 : 0;
            // console.log(status);
            $.ajax({
                type: "post",
                url: "<?php echo e(route('questmain.status')); ?>",
                data: {
                    _token: "<?php echo e(csrf_token()); ?>",
                    id: catId,
                    status: status
                },
                success: function(response) {


                    // console.log(response);
                    toastr.success("", response.message, {
                        timeOut: 4000,
                        closeButton: !0,
                        newestOnTop: !0,
                        progressBar: !0,
                        positionClass: "toast-top-right",

                    });
                },
                error: function(xhr, status, error) {
                    var errors = xhr.responseJSON.errors;
                    var errorMessage = '';

                    // Construct error message
                    $.each(errors, function(key, value) {
                        errorMessage += value + '<br>';
                    });

                    toastr.error("", errorMessage, {
                        timeOut: 5000,
                        closeButton: !0,
                        debug: !1,
                        newestOnTop: !0,
                        progressBar: !0,
                        positionClass: "toast-top-right",

                    });

                    // console.log(response);
                }
            });

        });
    </script>
    <script>
        $('#addform').submit(function(event) {
            event.preventDefault();
            var formData = new FormData(this);
            // console.log(formData)
            $.ajax({
                type: "POST",
                url: "<?php echo e(route('questmain.store')); ?>",
                data: formData,
                cache: false,
                contentType: false,
                processData: false,
                success: function(response) {

                    $('#addform')[0].reset();
                    // console.log(response);
                    toastr.success("", response.message, {
                        timeOut: 4000,
                        closeButton: !0,
                        newestOnTop: !0,
                        progressBar: !0,
                        positionClass: "toast-top-right",

                    });
                    window.location.reload();
                },
                error: function(xhr, status, error) {
                    var errors = xhr.responseJSON.errors;
                    var errorMessage = '';

                    // Construct error message
                    $.each(errors, function(key, value) {
                        errorMessage += value + '<br>';
                    });

                    toastr.error("", errorMessage, {
                        timeOut: 5000,
                        closeButton: !0,
                        debug: !1,
                        newestOnTop: !0,
                        progressBar: !0,
                        positionClass: "toast-top-right",

                    });

                    // console.log(response);
                }
            });

        });
    </script>

    <script>
        $('#updateform').submit(function(event) {
            event.preventDefault();
            var formData = new FormData(this);
            // console.log(formData)
            $.ajax({
                type: "POST",
                url: "<?php echo e(route('questmain.update')); ?>",
                data: formData,
                cache: false,
                contentType: false,
                processData: false,
                success: function(response) {
                    // console.log(response);
                    toastr.success("", response.message, {
                        timeOut: 4000,
                        closeButton: !0,
                        newestOnTop: !0,
                        progressBar: !0,
                        positionClass: "toast-top-right",

                    });
                },
                error: function(xhr, status, error) {
                    var errors = xhr.responseJSON.errors;
                    var errorMessage = '';

                    // Construct error message
                    $.each(errors, function(key, value) {
                        errorMessage += value + '<br>';
                    });

                    toastr.error("", errorMessage, {
                        timeOut: 5000,
                        closeButton: !0,
                        debug: !1,
                        newestOnTop: !0,
                        progressBar: !0,
                        positionClass: "toast-top-right",

                    });

                    // console.log(response);
                }
            });

        });
    </script>


    <script>
        $('.btn-delete').on('click', function() {
            var langid = $(this).data('cat-id');
            // console.log(langid);
            if (confirm('Are you sure? you want to delete this category.')) {
                $.ajax({
                    type: "post",
                    url: "<?php echo e(route('questmain.delete')); ?>",
                    data: {
                        _token: "<?php echo e(csrf_token()); ?>",
                        _method: "DELETE",
                        id: langid
                    },
                    success: function(response) {
                        $("#CatRow-" + langid).remove();
                        console.log(response);
                        toastr.success("", response.message, {
                            timeOut: 4000,
                            closeButton: !0,
                            newestOnTop: !0,
                            progressBar: !0,
                            positionClass: "toast-top-right",

                        });
                    },
                    error: function(xhr, status, error) {
                        var errors = xhr.responseJSON.errors;
                        var errorMessage = '';

                        // Construct error message
                        $.each(errors, function(key, value) {
                            errorMessage += value + '<br>';
                        });

                        toastr.error("", errorMessage, {
                            timeOut: 5000,
                            closeButton: !0,
                            debug: !1,
                            newestOnTop: !0,
                            progressBar: !0,
                            positionClass: "toast-top-right",

                        });

                        // console.log(response);
                    }
                });
            }
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Laravel\devquiz\resources\views/admin/questionAnswer/category.blade.php ENDPATH**/ ?>