<?php $__env->startSection('content'); ?>
    <div class="container-fluid">

        <!-- row -->
        <div class="row">

            <div class="col-xl-12 col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title"><?php echo e($page_title); ?></h4>
                    </div>
                    <div class="card-body">
                        <div class="basic-form">
                            <form id="updateform">
                                <?php echo csrf_field(); ?>
                                <div class="form-row">
                                    <input type="hidden" name="id" value="<?php echo e($data->id); ?>">
                                    <div class="form-group col-md-3 mb-2">
                                        <label for="language_id">Language*</label>
                                        <select name="language_id" id="language_id" class="form-control">
                                            <option value="">Select Language</option>
                                            <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($lang->id); ?>" <?php if($data->language_id==$lang->id): ?> selected <?php endif; ?>><?php echo e($lang->language_name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <div class="form-group col-md-3 mb-2">
                                        <label for="category_id">Category*</label>
                                        <select name="category_id" id="category_id" class="form-control">
                                            <option value="">Select Category</option>
                                            <?php $__currentLoopData = $maincategory; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($cat->id); ?>"  <?php if($data->category_id==$cat->id): ?> selected <?php endif; ?>><?php echo e($cat->category_name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <div class="form-group col-md-3 mb-2">
                                        <label for="subcategory_id">Sub Category</label>
                                        <select name="subcategory_id" id="subcategory_id"  class="form-control">
                                            <option value="">Select SubCategory</option>
                                            <?php $__currentLoopData = $subcategory; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subcat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($subcat->id); ?>"  <?php if($data->subcategory_id==$subcat->id): ?> selected <?php endif; ?>><?php echo e($subcat->subcategory_name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <div class="form-group col-md-3 mb-2">
                                        <label for="sub2category_id">Sub 2 Category</label>
                                        <select name="sub2category_id" id="sub2category_id" class="form-control">
                                            <option value="">Select Sub2 Category</option>
                                            <?php $__currentLoopData = $sub2category; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subcat2): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($subcat2->id); ?>"  <?php if($data->sub2category_id==$subcat2->id): ?> selected <?php endif; ?>><?php echo e($subcat2->sub2category_name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>

                                    <div class="form-group col-md-12 mb-2">
                                        <label for="comment">Question*</label>
                                        <textarea class="form-control"  rows="2" name="question" id="comment" placeholder="Enter qustion here..."><?php echo e($data->question ?? ''); ?></textarea>
                                    </div>

                                    <div class="form-group col-md-6 mb-2">
                                        <label for="first">Option 1st*</label>
                                        <input type="text" name="one" id="first"
                                        class="form-control" value="<?php echo e($data->one ?? ''); ?>" placeholder="Enter 1st option answer">
                                    </div>

                                    <div class="form-group col-md-6 mb-2">
                                        <label for="second">Option 2nd*</label>
                                        <input type="text" value="<?php echo e($data->two ?? ''); ?>" name="two" id="second"
                                        class="form-control" placeholder="Enter 2nd option answer">
                                    </div>

                                    <div class="form-group col-md-6 mb-2">
                                        <label for="third">Option 3rd*</label>
                                        <input type="text" name="three" id="third" value="<?php echo e($data->three ?? ''); ?>"
                                        class="form-control" placeholder="Enter 3rd option answer">
                                    </div>

                                    <div class="form-group col-md-6 mb-2">
                                        <label for="four">Option 4th*</label>
                                        <input type="text" name="four" id="four" value="<?php echo e($data->four ?? ''); ?>" class="form-control" placeholder="Enter 4th option answer">
                                    </div>

                                    <div class="form-group col-md-6 mb-2">
                                        <label for="answer">Answer*</label>
                                        <select name="answer" id="answer" required class="form-control">
                                            <option value="">Select Answer</option>
                                            <option value="one" <?php if($data->answer == 'one'): ?> selected <?php endif; ?>>1st</option>
                                            <option value="two"  <?php if($data->answer == 'two'): ?> selected <?php endif; ?>>2nd</option>
                                            <option value="three"  <?php if($data->answer == 'three'): ?> selected <?php endif; ?>>3rd</option>
                                            <option value="four"  <?php if($data->answer == 'four'): ?> selected <?php endif; ?>>4th</option>
                                        </select>
                                    </div>

                                    <div class="form-group col-md-6 mb-3">
                                        <label class="">Image (optional)</label>
                                        <div class="input-group">
                                            <div class="custom-file">
                                                <input type="file" name="image" class="form-control-file"
                                                    accept="image/*">

                                            </div>
                                            <?php if(!empty($data->image)): ?>
                                            <img src="<?php echo e(asset('/quiz/question/') . '/' . $data->image); ?>"
                                                width="100px" height='80px'>
                                        <?php endif; ?>
                                        </div>
                                    </div>

                                </div>
                                <div class="form-group row mt-4">
                                    <div class="col-sm-10 m-auto">
                                        <button type="submit" class="btn btn-primary btn-block">Submit</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
    $('#updateform').submit(function(event) {
        event.preventDefault();
        var formData = new FormData(this);
        // console.log(formData)
        $.ajax({
            type: "POST",
            url: "<?php echo e(route('quizquestion.update')); ?>",
            data: formData,
            cache: false,
            contentType: false,
            processData: false,
            success: function(response) {
                // console.log(response);
                toastr.success("", response.message, {
                    timeOut: 4000,
                    closeButton: !0,
                    newestOnTop: !0,
                    progressBar: !0,
                    positionClass: "toast-top-right",

                });
            },
            error: function(xhr, status, error) {
                var errors = xhr.responseJSON.errors;
                var errorMessage = '';

                // Construct error message
                $.each(errors, function(key, value) {
                    errorMessage += value + '<br>';
                });

                toastr.error("", errorMessage, {
                    timeOut: 5000,
                    closeButton: !0,
                    debug: !1,
                    newestOnTop: !0,
                    progressBar: !0,
                    positionClass: "toast-top-right",

                });

                // console.log(response);
            }
        });

    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Laravel\devquiz\resources\views/admin/quiz/update.blade.php ENDPATH**/ ?>