<?php $__env->startSection('content'); ?>
    <div class="container-fluid">

        <!-- row -->
        <div class="row">

            <div class="col-xl-12 col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title"><?php echo e($page_title); ?></h4>
                    </div>
                    <div class="card-body">
                        <div class="basic-form">
                            <form id="addform">
                                <?php echo csrf_field(); ?>
                                <div class="form-row">
                                    <div class="col-md-3 mb-2">
                                        <select name="language_id" id="" class="form-control">
                                            <option value="">Select Language</option>
                                            <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($lang->id); ?>"><?php echo e($lang->language_name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <div class="col-md-3 mb-2">
                                        <select name="category_id" id="" class="form-control">
                                            <option value="">Select Category</option>
                                            <?php $__currentLoopData = $maincategory; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($cat->id); ?>"><?php echo e($cat->category_name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <div class="col-md-3 mb-2">
                                        <select name="subcategory_id" id="" class="form-control">
                                            <option value="">Select SubCategory</option>
                                            <?php $__currentLoopData = $subcategory; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subcat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($subcat->id); ?>"><?php echo e($subcat->subcategory_name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <div class="col-md-3 mb-2">
                                        <input type="text" name="sub2category_name" id="sub2category_name"
                                            class="form-control" placeholder="Enter Sub 2 category name">
                                    </div>

                                    
                                    <div class="col-md-3 mb-2">
                                        <button type="submit" class="btn btn-primary btn-block">Submit</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>


            <div class="col-md-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Sub Category List</h4>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table id="example" class="display min-w850">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Language Name</th>
                                        <th>Category Name</th>
                                        <th>SubCategory Name</th>
                                        <th>Sub2Category Name</th>
                                        
                                        <th>Status</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $subcat2): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr id="CatRow-<?php echo e($subcat2->id); ?>">
                                            <td><?php echo e($key + 1); ?></td>
                                            <td><?php echo e($subcat2->languages->language_name ?? ''); ?></td>
                                            <td><?php echo e($subcat2->examcategory->category_name ?? ''); ?></td>
                                            <td><?php echo e($subcat2->examsubcategory->subcategory_name ?? ''); ?></td>
                                            <td><?php echo e($subcat2->sub2category_name ?? ''); ?></td>
                                            
                                            <td>
                                                <div class="custom-control custom-checkbox mb-3 checkbox-warning check-xl">
                                                    <input type="checkbox" class="custom-control-input btn-status"
                                                        id="check-<?php echo e($subcat2->id); ?>" data-catid="<?php echo e($subcat2->id); ?>"
                                                        <?php echo e($subcat2->status ? 'checked' : ''); ?>>
                                                    <label class="custom-control-label"
                                                        for="check-<?php echo e($subcat2->id); ?>"></label>
                                                </div>
                                            </td>
                                            <td>
                                                <div class="d-flex">
                                                    <a data-subcat2-id="<?php echo e($subcat2->id); ?>"
                                                        data-lang-id="<?php echo e($subcat2->language_id); ?>"
                                                        data-cat-id="<?php echo e($subcat2->category_id); ?>"
                                                        data-subcat-id="<?php echo e($subcat2->subcategory_id); ?>"
                                                        data-subcat2-name="<?php echo e($subcat2->sub2category_name); ?>"
                                                        class="btn btn-primary shadow btn-xs sharp mr-1 btn-edit text-white"><i
                                                            class="fa fa-pencil"></i></a>
                                                    <a class="btn btn-danger shadow btn-xs sharp btn-delete text-white"
                                                        data-subcat2-id="<?php echo e($subcat2->id); ?>"><i
                                                            class="fa fa-trash"></i></a>
                                                </div>
                                            </td>

                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>

                            </table>


                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>


    
    <div class="modal fade" id="editmodal">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Edit Sub Category</h5>
                    <button type="button" class="close" data-dismiss="modal"><span>&times;</span>
                    </button>
                </div>
                <form id="updateform">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <input type="hidden" name="id" value="" id="subcatid">
                        <div class="form-group">
                            <select name="language_id" id="lang_id" class="form-control">
                                <option value="">Select Language</option>
                                <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($lang->id); ?>"><?php echo e($lang->language_name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <br>
                        <div class="form-group">
                            <select name="category_id" id="cat_id" class="form-control">
                                <option value="">Select Category</option>
                                <?php $__currentLoopData = $maincategory; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($cat->id); ?>"><?php echo e($cat->category_name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <br>
                        <div class="form-group">
                            <select name="subcategory_id" id="subcat_id" class="form-control">
                                <option value="">Select Sub Category</option>
                                <?php $__currentLoopData = $subcategory; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subcat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($subcat->id); ?>"><?php echo e($subcat->subcategory_name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <br>
                        <input type="text" name="sub2category_name" value="" maxlength="30" class="form-control"
                            id="subcat2_name" placeholder="Sub2Category Name"
                            oninput="this.value = this.value.replace(/[^a-zA-Z .]/g, ''); this.value = this.value.replace(/(\..*)\./g, '$1');">
                    </div>
                    <div class="modal-footer">
                        
                        <button type="submit" class="btn btn-primary">Save changes</button>
                    </div>

                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script>
        $(document).ready(function() {

            $('.btn-edit').on('click', function() {

                $('#editmodal').modal('show');
                let subcat2Id = $(this).data('subcat2-id');
                let subcat2Name = $(this).data('subcat2-name');
                let langid = $(this).data('lang-id');
                let catid = $(this).data('cat-id');
                let subcatid = $(this).data('subcat-id');
                $("#subcatid").val(subcat2Id); // Corrected variable name
                $("#subcat2_name").val(subcat2Name); // Corrected variable name
                $('#editmodal select[id="lang_id"]').find('option[value="' + langid + '"]').prop('selected',
                    true);
                $('#editmodal select[id="cat_id"]').find('option[value="' + catid + '"]').prop('selected',
                    true);
                $('#editmodal select[id="subcat_id"]').find('option[value="' + subcatid + '"]').prop(
                    'selected',
                    true);
            });
        });
    </script>

    <script>
        $('.btn-status').on('click', function() {
            var catId = $(this).data('catid');
            var status = $(this).is(':checked') ? 1 : 0;
            // console.log(status);
            $.ajax({
                type: "post",
                url: "<?php echo e(route('examsub2.status')); ?>",
                data: {
                    _token: "<?php echo e(csrf_token()); ?>",
                    id: catId,
                    status: status
                },
                success: function(response) {

                    // console.log(response);
                    toastr.success("", response.message, {
                        timeOut: 4000,
                        closeButton: !0,
                        newestOnTop: !0,
                        progressBar: !0,
                        positionClass: "toast-top-right",

                    });
                },
                error: function(xhr, status, error) {
                    var errors = xhr.responseJSON.errors;
                    var errorMessage = '';

                    // Construct error message
                    $.each(errors, function(key, value) {
                        errorMessage += value + '<br>';
                    });

                    toastr.error("", errorMessage, {
                        timeOut: 5000,
                        closeButton: !0,
                        debug: !1,
                        newestOnTop: !0,
                        progressBar: !0,
                        positionClass: "toast-top-right",

                    });

                    // console.log(response);
                }
            });

        });
    </script>
    <script>
        $('#addform').submit(function(event) {
            event.preventDefault();
            var formData = new FormData(this);
            $.ajax({
                type: "POST",
                url: "<?php echo e(route('examsub2.store')); ?>",
                data: formData,
                cache: false,
                contentType: false,
                processData: false,
                success: function(response) {
                    $('#addform').find('input[type="text"]').val('');
                    // Reset select elements
                    $('#addform').find('select').prop('selectedIndex', 0);
                    toastr.success("", response.message, {
                        timeOut: 4000,
                        closeButton: true,
                        newestOnTop: true,
                        progressBar: true,
                        positionClass: "toast-top-right"
                    });
                    window.location.reload();
                },
                error: function(xhr, status, error) {
                    var errors = xhr.responseJSON.errors;
                    var errorMessage = '';
                    // Construct error message
                    $.each(errors, function(key, value) {
                        errorMessage += value + '<br>';
                    });
                    // Display error message
                    toastr.error("", errorMessage, {
                        timeOut: 5000,
                        closeButton: true,
                        debug: false,
                        newestOnTop: true,
                        progressBar: true,
                        positionClass: "toast-top-right"
                    });
                }
            });
        });
    </script>


    <script>
        $('#updateform').submit(function(event) {
            event.preventDefault();
            var formData = new FormData(this);
            // console.log(formData)
            $.ajax({
                type: "POST",
                url: "<?php echo e(route('examsub2.update')); ?>",
                data: formData,
                cache: false,
                contentType: false,
                processData: false,
                success: function(response) {
                    // console.log(response);
                    toastr.success("", response.message, {
                        timeOut: 4000,
                        closeButton: !0,
                        newestOnTop: !0,
                        progressBar: !0,
                        positionClass: "toast-top-right",

                    });
                },
                error: function(xhr, status, error) {
                    var errors = xhr.responseJSON.errors;
                    var errorMessage = '';

                    // Construct error message
                    $.each(errors, function(key, value) {
                        errorMessage += value + '<br>';
                    });

                    toastr.error("", errorMessage, {
                        timeOut: 5000,
                        closeButton: !0,
                        debug: !1,
                        newestOnTop: !0,
                        progressBar: !0,
                        positionClass: "toast-top-right",

                    });

                    // console.log(response);
                }
            });

        });
    </script>


    <script>
        $('.btn-delete').on('click', function() {
            var subcatid = $(this).data('subcat2-id');
            // console.log(langid);
            if (confirm('Are you sure? you want to delete this Sub 2 category.')) {
                $.ajax({
                    type: "post",
                    url: "<?php echo e(route('examsub2.delete')); ?>",
                    data: {
                        _token: "<?php echo e(csrf_token()); ?>",
                        _method: "DELETE",
                        id: subcatid
                    },
                    success: function(response) {
                        $("#CatRow-" + subcatid).remove();
                        console.log(response);
                        toastr.success("", response.message, {
                            timeOut: 4000,
                            closeButton: !0,
                            newestOnTop: !0,
                            progressBar: !0,
                            positionClass: "toast-top-right",

                        });
                    },
                    error: function(xhr, status, error) {
                        var errors = xhr.responseJSON.errors;
                        var errorMessage = '';

                        // Construct error message
                        $.each(errors, function(key, value) {
                            errorMessage += value + '<br>';
                        });

                        toastr.error("", errorMessage, {
                            timeOut: 5000,
                            closeButton: !0,
                            debug: !1,
                            newestOnTop: !0,
                            progressBar: !0,
                            positionClass: "toast-top-right",

                        });

                        // console.log(response);
                    }
                });
            }
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Laravel\devquiz\resources\views/admin/exam/sub2category.blade.php ENDPATH**/ ?>